/* filterrules
 * Copyright (C) 1999 Herve Schauer Consultants and Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *//*
 * $Id: ttls.c,v 1.3 1999/09/21 15:34:44 renaud Exp $
 *
 * Author : Renaud Deraison <deraison@hsc.fr>
 *
 */

#include <includes.h>
#include "tests.h"
/*
 *
 *			Times To Live
 *
 *
 *	These functions are used to keep track of the TTL
 * to set to packets going to a given host. All of these functions
 * are only useful when the -r (remote) option has been set.
 *
 */


extern int Remote;

/*
 * Handy functions to keep track of the TTLs
 */
struct ttls {
	struct in_addr host;
	int ttl;
	 };
	 
struct ttls ttls[1024];



void 
init_ttl_table()
{
 int i;
 for(i=0;i<1024;i++)bzero(&(ttls[i]), sizeof(ttls[i]));
}

void
add_ttl_to_host(host, ttl)
	struct in_addr host;
	int ttl;
{
 int i=0;
 while((ttls[i].host.s_addr) && (ttls[i].host.s_addr!=host.s_addr)&&(i<1024))i++;
 if(i>=1024)
 {
  printf("ERROR ! The ttls table is full -- did you enter more than 1024 TTLs ?\n");
  exit(1);
 }
 if(!ttls[i].host.s_addr)ttls[i].host.s_addr = host.s_addr;
 ttls[i].ttl = ttl;
}

int
get_ttl_to_host(host)
 struct in_addr host;
{
 int i=0;
 while((ttls[i].host.s_addr)&&(ttls[i].host.s_addr!=host.s_addr)&&(i<1024))i++;
 if(ttls[i].host.s_addr)return(ttls[i].ttl);
 else return(-1);
}

/*
 * Forger callback
 */
struct test * ttl_parser(str, test)
 char * str;
 struct test * test;
{
 int ttl =  atoi(str);
 test->proto = 0;
 add_ttl_to_host(test->dst, ttl);
 return(test);
}
 

int get_ttl(host)
{
 int ttl;
 if(!Remote)return(0x40);
 if((ttl = get_ttl_to_host(host))>=0)return(ttl);
 else return(-1); /* add here functions to determine the proper ttl */
}
 
/*
 * Add the functions designed to determine the remote host TTL
 * here 
 */

