/* filterrules
 * Copyright (C) 1999 Herve Schauer Consultants and Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: udp.c,v 1.20 1999/09/21 15:34:44 renaud Exp $
 *
 * Author : Renaud Deraison <Renaud.Deraison@hsc.fr>
 *
 */

#include <includes.h>
#include <libnet.h>
#include "matrix.h"
#include "forgers.h"
#include "utils.h"
#include "tests.h"
#include "source_route.h"
#include "ttls.h"

/*
 * 				UDP
 *
 * see tcp.c for details on how the replies are stored
 *
 */
extern int RawSoc;
extern int Policy;
extern matrix Matrix;
extern u_short MatrixX;


/*
 * Public functions
 */
char * udp_filter(test,y)
 struct test * test;
 int y;
{
 char * asc_src = (char*)strdup(inet_ntoa(test->src));
 char * asc_dst = (char*)strdup(inet_ntoa(test->dst));
 char * ret = malloc(strlen(asc_src)+strlen(asc_dst)+200);
 u_short * sport = (u_short *)test->udp_sport;
 
 sprintf(ret, "FILTER udp and (src host %s and dst host %s and src port %d)",
 			asc_src,asc_dst,sport[y]);
 free(asc_src);
 free(asc_dst);			
 realloc(ret, strlen(ret)+1);
 return(ret);
}




struct test * udp_parser(str, test)
 char * str;
 struct test * test;
{
 char *d = (char*)strchr(str, ':');
 
 test->proto = IPPROTO_UDP;
 test->num_data = 0;
 if(d)d[0]=0;
 test->udp_sport=(long)getpts(str,0);
 test->num_data++;
 str = d+1;
 d = (char*)strchr(str, ':');
 if(d)d[0]='\0';
 test->num_data++;
 test->udp_dport=(long)getpts(str,0);
 str = d+1;
 if(d)source_route_parser(test, d);
 else test->source_route = 0;
 test->soc = RawSoc;
 return(test);
}


void udp_receiver(test, pkt)
 struct test * test;
 u_char * pkt;
{
 struct libnet_ip_hdr * ip = (struct libnet_ip_hdr*)(pkt);
 struct libnet_udp_hdr * udp =(struct libnet_udp_hdr*)(pkt+ip->ip_hl*4);
 matrix_set_element(Matrix,PKT_PASSED, 
   			(u_short*)test->udp_sport, 
   			(u_short*)test->udp_dport, 
   			ntohs(udp->uh_sport),
			ntohs(udp->uh_dport));
}



int udp_sender(test, x,y)
 struct test * test;
 int x,y;
{
 u_char * buf;
 u_short * sport, * dport;
 struct libnet_ip_hdr * ip;
 int ttl;
 if((libnet_init_packet(IP_H+UDP_H+40, &buf))<0)
 {
  printf("Could not allocate a packet\n");
  exit(1);
 }
 ip = (struct libnet_ip_hdr *)buf;
 sport = (u_short *)test->udp_sport;
 dport = (u_short *)test->udp_dport;
 ttl = get_ttl(test->dst);
 build_ip(UDP_H, 0, 1234, 0, ttl, IPPROTO_UDP,test->src.s_addr, 
 	  test->dst.s_addr, NULL, 0, buf);
 build_udp(sport[y],dport[x], NULL, 0, buf + IP_H);
 if(test->source_route)insert_source_route(test, buf);    
 do_checksum(buf, IPPROTO_UDP, UDP_H);
 write_ip(test->soc, buf, UDP_H + ip->ip_hl*4);
 free(buf);
 return(0);
}


char * udp_display(test,x)
 struct test * test;
 int x;
{
 char * ret = malloc(2048);
 char * asc_src = strdup(inet_ntoa(test->src));
 char * asc_dst = strdup(inet_ntoa(test->dst));
 u_short * sport = (u_short *)test->udp_sport;
 char * ports;
 

 ports = matrix_elements(Matrix,PKT_PASSED,
 			 	(u_short*)test->udp_dport,
				x,MatrixX,&test->policy,0);
 						
 
 sprintf(ret, "udp from %s %d to %s %s",
 		asc_src,sport[x],
		asc_dst,ports);
 /* free(ports); */
 free(asc_src);
 free(asc_dst);
 realloc(ret, strlen(ret)+1);
 return(ret);
}		


void udp_router_err(test, pkt, index, err,code)
 struct test * test;
 u_char * pkt;
 int index;
 int err;
{
 struct libnet_ip_hdr * ip = (struct libnet_ip_hdr *)pkt;
 struct libnet_udp_hdr * udp = (struct libnet_udp_hdr*)
 				((u_char*)ip+ip->ip_hl*4);
 int sport, dport;
 
 sport = ntohs(udp->uh_sport);
 dport = ntohs(udp->uh_dport);
 if(err==3) /* ICMP UNREACH */
 matrix_set_element(Matrix, (index<<8)|(code+2),
 			(u_short*)test->udp_sport,
			(u_short*)test->udp_dport,
			sport, dport);
 else if(err==11) /* ICMP time exceed */
 
   matrix_set_element(Matrix, 1,
 			(u_short*)test->udp_sport,
			(u_short*)test->udp_dport,
			sport, dport);
 			
}	
