

/*
 * $Id: slave.c,v 1.13 1999/09/21 14:54:45 renaud Exp $
 *
 * Author : Renaud Deraison <Renaud.Deraison@hsc.fr>
 */
#include <includes.h>
#include <syslog.h>
/*
 * 'Slave'
 *
 * This program only listens on a given port and sends
 * to its master the packets that match the filter it has
 * been given.
 *
 * Default port : 19231
 *
 * This program does not handle more than one connection at a time, 
 * this is intentional.
 *
 *
 * TODO :
 *	- XXX must provide some authentification
 *
 */
 
#define MSG_QUIT "QUIT"
#define MSG_FILTER "FILTER"
#define MSG_MODE "MODE"
#define MSG_STOP "STOP"
#define MSG_OK	 "OK"

pcap_t * Pcap;
char *Iface;
char Errbuf[PCAP_ERRBUF_SIZE];
int Has_filter = 0;
int Soc = 0;
char * OldFilter = NULL;


/*
 * When a message of type 'FILTER' is sent, then
 * the slave will call this function, which applies
 * the filter contained in the message on the pcap
 *
 */
void apply_filter(filtermsg)
 char * filtermsg;
{
 char * filter = (char*)strchr(filtermsg, ' ');
 char *f = malloc(strlen(filter)+1);
 struct bpf_program * filter_prog = malloc(sizeof(struct bpf_program));
 bpf_u_int32 netmask, network;
 
 strncpy(f, filter, strlen(filter)+1);
 filter = f;

 filter = (char*)strdup(filter);
 while((filter[strlen(filter)-1]=='\n')||
 	(filter[strlen(filter)-1]=='\r'))filter[strlen(filter)-1]='\0';
	
 if(OldFilter && !strcmp(OldFilter, filter)){
 	free(filter);
	free(f);
	return;
	}
 if(OldFilter)free(OldFilter);	
 OldFilter = strdup(filter);
 pcap_lookupnet(Iface, &network, &netmask, 0);
 if((pcap_compile(Pcap, filter_prog, filter, 0, netmask))<0)
 {
  printf("filter compilation error\n");
  exit(1);
 }
 if((pcap_setfilter(Pcap, filter_prog))<0)
 {
  printf("could not apply filter\n");
  exit(1);
 }
}


/*
 * as soon as pcap_next() gives us a packet,
 * we send it to the master, without even looking
 * at it
 */
void send_incoming_packets(soc)
 int soc;
{
 int dl = pcap_datalink(Pcap);
 struct pcap_pkthdr head;
 const char * pkt;
 int len = 0;
 
 switch(dl)
 {
  case DLT_EN10MB: len = 14; break;
  case DLT_IEEE802: len = 22; break;
  case DLT_NULL: len = 4; break;
  case DLT_PPP : len = 4; break;
  case DLT_SLIP : len = 0x10;break;
  case DLT_RAW: len = 0; break;
  default : printf("You link layer is not supported\n");
  	    exit(1);
 }

 pkt = pcap_next(Pcap, &head);
 if(pkt)
 {
  int i;
  char * buf = (char *)malloc(2000);
  fd_set rd;
  struct timeval tv;
  bzero(buf, 2000);
  buf[0]='(';
  for(i=len;i<(head.caplen+len);i++)
   sprintf(buf, "%s %x", buf, (unsigned char)pkt[i]);
  
  i = strlen(buf);
  buf[i++]=' ';
  buf[i++] = ')';
  buf[i++]='\r';
  buf[i++]='\n';
  buf[i++]=0;
  send(soc, buf, strlen(buf)+1, 0);
#ifdef DEBUG
  printf("sent %s\n", buf);
#endif
  tv.tv_sec = 2;
  tv.tv_usec = 0;
  FD_ZERO(&rd);
  FD_SET(soc, &rd);
  select(soc+1, &rd, NULL,NULL, &tv);
  if(FD_ISSET(soc, &rd)){
  	 bzero(buf, 2000);
  	recv(soc, buf, 1024, 0);
#ifdef DEBUG	
	printf("received : %s\n", buf);
#endif	
	 if(!strncmp(buf, MSG_STOP, strlen(MSG_STOP))){
  		Has_filter = 0;
		send(soc, "OK\n", 3, 0);
		}
	}
  else {
#ifdef DEBUG  
  	printf("Did not receive confirmation -- sending once more\n");
#endif	
	send(soc, buf, strlen(buf)+1, 0);
	tv.tv_sec = 2;
  	tv.tv_usec = 0;
  	FD_ZERO(&rd);
  	FD_SET(soc, &rd);
  	select(soc+1, &rd, NULL,NULL, &tv);
  	if(FD_ISSET(soc, &rd)){
  	 bzero(buf, 2000);
  	 recv(soc, buf, 1024, 0);
#ifdef DEBUG	
	 printf("received : %s\n", buf);
#endif	 
	 if(!strncmp(buf, MSG_STOP, strlen(MSG_STOP))){
  		Has_filter = 0;
		send(soc, "OK\n", 3, 0);
		}
	} else printf("Still no confirmation -- going ahead\n");
      }
 
  free(buf);
 }
}
   

void obey_to_master(soc)
 int soc;
{
 fd_set rd, wr;
 struct timeval tv = {0,500};
 char * buffer;
 
 for(;;)
 {
  tv.tv_sec = 0;
  tv.tv_usec = 10;
  
  FD_ZERO(&rd);FD_ZERO(&wr);
  FD_SET(soc, &rd);
  FD_SET(soc, &wr);
  if((select(soc+1, &rd, &wr,NULL,&tv))<0)
 {
  perror("select ");
  exit(1);
 }
 if(!FD_ISSET(soc, &wr)){
 	/* connection closed -- we just reset */
	Has_filter = 0;
	shutdown(soc, 2);
	close(soc);
	return;
 	}
 if(FD_ISSET(soc, &rd))
 {
  buffer = malloc(1024);
  bzero(buffer, 1024);
  recv(soc, buffer, 1024, 0);
  if(!strlen(buffer))
  {
   Has_filter = 0;
   shutdown(soc,2);
   close(soc);
   return;
  }
#ifdef DEBUG  
  printf("received %s\n", buffer);
#endif  
  if(!strncmp(buffer, MSG_QUIT, strlen(MSG_QUIT))){
  	free(buffer);
	pcap_close(Pcap);
	shutdown(Soc, 2);
	close(Soc);
	exit(0);
	}
  if(!strncmp(buffer, MSG_STOP, strlen(MSG_STOP))){
  	Has_filter = 0;
	send(soc, "OK\n", 3, 0);
	free(buffer);
	}
  if(!strncmp(buffer, MSG_FILTER, strlen(MSG_FILTER))){
  	apply_filter(buffer);
	send(soc, "OK\n", 3, 0);
	Has_filter = 1;
	free(buffer);
	}
 }
 
 if(Has_filter)send_incoming_packets(soc);
 else usleep(200);
 }
} 
 
 
/*
 * open a socket on port <port> of interface
 * iaddr (or on all the interfaces if iaddr.s_addr
 * is equal to 0)
 *
 * Then, accept incoming requests
 */
void init_network(port, iaddr)
	int port;
	struct in_addr iaddr;
{
 int soc;
 struct sockaddr_in addr;
 int option = 1;
 if((soc = socket(AF_INET, SOCK_STREAM, 0))<0)
 {
  perror("socket ");
  exit(1);
 }
 setsockopt(soc, SOL_SOCKET, SO_REUSEADDR, &option, sizeof(int));

 Soc = soc;
 bzero(&addr, sizeof(addr));
 addr.sin_family = AF_INET;
 addr.sin_port = htons(port);
 addr.sin_addr.s_addr = iaddr.s_addr;
 if((bind(soc, (struct sockaddr *)&addr, sizeof(struct sockaddr_in)))<0)
 {
  perror("bind ");
  exit(1);
 }
 
 if((listen(soc, 1))<0)
 {
  perror("listen ");
  exit(1);
 }
 
 while(1)
 {
  int client;
  int lg;
  struct sockaddr_in sockaddr;
  lg = sizeof(struct sockaddr);
  client = accept(soc, (struct sockaddr *)&sockaddr, &lg);
  if(client == -1){
  	if(errno == EINTR)continue;
	else { perror("accept ");exit(1);}
	}
  /* 
   * if we wanted this tool to answer to more than
   * one master, we would use fork() here, and re-open a
   * pcap
   */
  {
   char * log = malloc(600);
   sprintf(log, "Connection from %s\n", inet_ntoa(sockaddr.sin_addr));
   syslog(LOG_NOTICE, log);
   free(log);
  }
  obey_to_master(client);
  }
}


/*
 * open a packet capture module
 * on interface <iface> or on the default
 * interface if iface==NULL
 */
void init_pcap(iface)
 char * iface;
{
 if(!iface)iface = pcap_lookupdev(Errbuf);
 if(!iface){
 	printf("pcap_lookupdev : %s\n", Errbuf);
	exit(1);
	}
 Iface = iface;
 Pcap = pcap_open_live(iface, 128, 1,100,Errbuf);
 if(!Pcap){
 	printf("pcap_open_live : %s\n", Errbuf);
	exit(1);
	}
}


void usage()
{
 printf("slave [-a listen address] [-p port] [-i interface]\n");
 exit(1);
}



int main(argc, argv)
	int argc;
	char  * argv[];
{
 int port = 19123;
 int i;
 struct in_addr addr;
 char * iface = NULL;
 bzero(&addr, sizeof(addr));
 
 while((i=getopt(argc, argv, "a:p:i:v"))!=-1)switch(i)
 {
  case 'a' : 
 	if(!optarg)usage();
	inet_aton(optarg, &addr);
	break;
  case 'p': 
  	if(!optarg)usage();
	port = atoi(optarg);
	break;
  case 'i' :
  	if(!optarg)usage();
	iface = strdup(optarg);
	break;
 case 'v' : 
 	printf("fr_slave, version %s\n", VERSION);
	printf("\tCopyright (C) 1999 Herve Schauer Consultants - http://www.hsc.fr\n");
	printf("\t               and Renaud Deraison <deraison@cvs.nessus.org>\n");
	exit(0);
	break;
 } 	
 
 init_pcap(iface);
 openlog("filterrules slave", 0,LOG_DAEMON);
 init_network(port, addr);
 return(0);
}


#ifndef HAVE_INET_ATON
/*
 * Coming straight from Fyodor's Nmap
 */
int
inet_aton(cp, addr)
	register const char *cp;
	struct in_addr *addr;
{
	register unsigned int val;	/* changed from u_long --david */
	register int base, n;
	register char c;
	u_int parts[4];
	register u_int *pp = parts;

	c = *cp;
	for (;;) {
		/*
		 * Collect number up to ``.''.
		 * Values are specified as for C:
		 * 0x=hex, 0=octal, isdigit=decimal.
		 */
		if (!isdigit((int)c))
			return (0);
		val = 0; base = 10;
		if (c == '0') {
			c = *++cp;
			if (c == 'x' || c == 'X')
				base = 16, c = *++cp;
			else
				base = 8;
		}
		for (;;) {
			if (isascii((int)c) && isdigit((int)c)) {
				val = (val * base) + (c - '0');
				c = *++cp;
			} else if (base == 16 && isascii((int)c) && isxdigit((int)c)) {
				val = (val << 4) |
					(c + 10 - (islower((int)c) ? 'a' : 'A'));
				c = *++cp;
			} else
				break;
		}
		if (c == '.') {
			/*
			 * Internet format:
			 *	a.b.c.d
			 *	a.b.c	(with c treated as 16 bits)
			 *	a.b	(with b treated as 24 bits)
			 */
			if (pp >= parts + 3)
				return (0);
			*pp++ = val;
			c = *++cp;
		} else
			break;
	}
	/*
	 * Check for trailing characters.
	 */
	if (c != '\0' && (!isascii((int)c) || !isspace((int)c)))
		return (0);
	/*
	 * Concoct the address according to
	 * the number of parts specified.
	 */
	n = pp - parts + 1;
	switch (n) {

	case 0:
		return (0);		/* initial nondigit */

	case 1:				/* a -- 32 bits */
		break;

	case 2:				/* a.b -- 8.24 bits */
		if (val > 0xffffff)
			return (0);
		val |= parts[0] << 24;
		break;

	case 3:				/* a.b.c -- 8.8.16 bits */
		if (val > 0xffff)
			return (0);
		val |= (parts[0] << 24) | (parts[1] << 16);
		break;

	case 4:				/* a.b.c.d -- 8.8.8.8 bits */
		if (val > 0xff)
			return (0);
		val |= (parts[0] << 24) | (parts[1] << 16) | (parts[2] << 8);
		break;
	}
	if (addr)
		addr->s_addr = htonl(val);
	return (1);
}
#endif



