/* filterrules
 * Copyright (C) 1999 Herve Schauer Consultants and Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: filters.c,v 1.4 1999/09/21 15:34:42 renaud Exp $
 *
 * Author : Renaud Deraison <deraison@nessus.org>
 *
 */


#include <includes.h>
#include <libnet.h>
#include "forgers.h" 
#include "inputs.h"
#include "utils.h"
#include "routers.h"
#include "matrix.h"
#include "tests.h"
#include "master_pcap.h"

/*
 * Libpcap filters manager
 *
 * The libpcap don't like when twice the same filter is applied.
 * In addition to that, many (if not most) of the protocols share the
 * same local filter.
 *
 * This file contains the 'standard' filters, as used by many protocols
 *
 * It's also in charge of changing (or not) the pcap filter.
 *
 *
 */
 

/*
 * The libpcap _hates_ when you ask it to change its
 * filter whereas it's the same. That's why we must compare
 * the new filter to the old one, and change it only if
 * this is necessary.
 */
char * OldFilter = NULL;
extern pcap_t * Pcap;
extern int Remote;


/*
 * When we are in 'remote' mode, then the filter
 * is only interested in the ICMP unreachable messages
 */
char *
filters_remote_mode(test)
 struct test * test;
{
 char * asc_src = strdup(inet_ntoa(test->src));
 char * ret = malloc(strlen(asc_src)+1024);
 if(!Remote)
  sprintf(ret, "(icmp[0]==3) and (dst host %s)", asc_src);
 else 
  sprintf(ret, "((icmp[0]==3) or (icmp[0]==11)) and (dst host %s)", asc_src);

 free(asc_src);
 realloc(ret, strlen(ret)+1);
 return(ret);
}


/*
 * This function will change the pcap filter _only if necessary_
 * That is, only if the new filter is not the same as the old one
 */
void 
change_filter(new_filter)
 char * new_filter;
{
 if(OldFilter && !strcmp(OldFilter, new_filter))return;
 else 
 { 
  if(OldFilter)free(OldFilter);
  OldFilter = strdup(new_filter);
  pcap_apply_filter(Pcap, new_filter);
 }
}
 
