/* filterrules
 * Copyright (C) 1999 Herve Schauer Consultants and Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: forgers.c,v 1.13 1999/09/21 15:34:42 renaud Exp $
 *
 * Author : Renaud Deraison <deraison@nessus.org>
 *
 */
#include <includes.h>
#include "tcp.h"
#include "udp.h"
#include "icmp.h"
#include "forgers.h"
#include "ipfrag.h"
#include "filters.h"
#include "ttls.h"

/* 
 * This file is the main point to add any protocol.
 *
 * It's more convienient to use those 'callbacks'
 * rather than putting a lot of 'switch()' and 'if' depending
 * on each protocol studied. It also makes the addition of
 * new protocols really easy.
 *
 * Once a forger has been initialized, it sends packet via its
 * 'sender' function, process them via its 'receiver' function
 * and so on.
 *
 * A 'forger' is a structure which holds several functions :
 *	- set up the slave pcap filter
 *	- set up the master pcap filter
 *	- send forged packets
 *	- receive packets received by the slave
 *	- receive packets received by the master
 *
 * Currently, they all share the same local_filter function which
 * is waiting for icmp unreachable errors coming from the gateways.
 */


/* 
 * Yet another global variable
 */
struct forgers * Forgers;



/*
 * Return the forger which is in charge of the 
 * protocol 'proto'. If no forger is found, 
 * then return NULL
 */
struct forgers * forger_get(proto)
 char * proto;
{
 struct forgers * f = Forgers;
 while(f)
 {
  if(!strcmp(f->asc_protocol,proto))return(f);
  f = f->next;
 }
 return(f);
}


/*
 * Add the forger in charge of the TCP protocol
 */
static void forgers_add_tcp(f)
 struct forgers * f;
{
 f->protocol = IPPROTO_TCP;
 f->asc_protocol = strdup("tcp");
 f->filter = tcp_filter;
 f->local_filter = filters_remote_mode;
 f->sender = tcp_sender;
 f->receiver = tcp_receiver;
 f->parser = tcp_parser;
 f->display= tcp_display; 
 f->router_err = tcp_router_err;
 f->translate = 0;
}

/*
 * Add the forger in charge of the ICMP protocol
 */
static void forgers_add_icmp(f)
 struct forgers * f;
{
 f->protocol = IPPROTO_ICMP;
 f->asc_protocol = strdup("icmp");
 f->filter = icmp_filter;
 f->local_filter = filters_remote_mode;
 f->sender = icmp_sender;
 f->receiver = icmp_receiver;
 f->parser = icmp_parser;
 f->display= icmp_display; 
 f->router_err = icmp_router_err;
 f->translate = 0;
}

/*
 * Add the forger in charge of the UDP protocol
 */
static void forgers_add_udp(f)
 struct forgers * f;
{
 f->protocol = IPPROTO_UDP;
 f->asc_protocol = strdup("udp");
 f->filter = udp_filter;
 f->local_filter = filters_remote_mode;
 f->sender = udp_sender;
 f->receiver = udp_receiver;
 f->parser = udp_parser;
 f->display= udp_display; 
 f->router_err = udp_router_err;
 f->translate = 0;
}


/*
 * Add the forger in charge of sending fragmented IP packets
 */
static void forgers_add_ipfrag(f)
 struct forgers * f;
{
 f->protocol = IPPROTO_RAW;
 f->asc_protocol = strdup("ipfrag");
 f->filter = ipfrag_filter;
 f->local_filter = filters_remote_mode;
 f->sender = ipfrag_sender;
 f->receiver = ipfrag_receiver;
 f->parser = ipfrag_parser;
 f->display= ipfrag_display; 
 f->router_err = ipfrag_router_err;
 f->translate = 0;
}

/*
 * Add the forger in charge of parsing the TTL option
 */
static void forgers_add_ttls(f)
 struct forgers * f;
{
 f->protocol = 0;
 f->asc_protocol = strdup("ttl");
 f->parser = ttl_parser;
}

/*
 * Feel free to add your forger function here 
 */


/*
 * This function initializes the global Forgers
 * variable, and fills it with all the forgers we 
 * have
 */
void init_forgers()
{
 struct forgers *t;
 
 Forgers  = malloc(sizeof(struct forgers));
 bzero(Forgers, sizeof(struct forgers));
 t = Forgers;
 forgers_add_tcp(t);
 
 t->next = malloc(sizeof(struct forgers));
 t = t->next;
 bzero(t, sizeof(struct forgers));
 forgers_add_udp(t);

 t->next = malloc(sizeof(struct forgers));
 t = t->next;
 bzero(t, sizeof(struct forgers));
 forgers_add_icmp(t);
 
 t->next = malloc(sizeof(struct forgers));
 t = t->next;
 bzero(t, sizeof(struct forgers));
 forgers_add_ipfrag(t); 
 
 
 t->next = malloc(sizeof(struct forgers));
 t = t->next;
 bzero(t, sizeof(struct forgers));
 forgers_add_ttls(t);
 /*
  * add the other protos here...
  */
}



 
