/* filterrules
 * Copyright (C) 1999 Herve Schauer Consultants and Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: icmp.c,v 1.11 1999/09/21 15:34:42 renaud Exp $
 *
 * Author : Renaud Deraison <deraison@nessus.org>
 *
 */
#include <includes.h>
#include <libnet.h>
#include "matrix.h"
#include "forgers.h"
#include "utils.h"
#include "tests.h"
#include "source_route.h"
#include "ttls.h"
/*
 * 				ICMP
 *
 * the ICMP packets have some sort of ports pairs : their type and
 * code. Yes, this is not an actual port, but this is useful to us
 * since we can easily use these to store the ICMP packets in our
 * matrix the same way we store our UDP and TCP packets with their
 * destination port and source port.
 *
 * The problem being that the TCP and UDP ports start at 1, whereas
 * the ICMP type and code start at 0. So, we do a dirty trick to get
 * around this problem : all ICMP data we will store will have an 
 * increased type and code. 
 * So, to get the actual code, we'll have to substract one from the
 * code value we have.
 *
 */
 
extern int RawSoc;
extern int Policy;
extern matrix Matrix;
extern u_short MatrixX,MatrixY;
extern int Remote;
 
 
/*
 * Returns the proper pcap filter for the current
 * test
 */
char * icmp_filter(test,y)
 struct test * test;
 int y;
{
 char * asc_src = (char*)strdup(inet_ntoa(test->src));
 char * asc_dst = (char*)strdup(inet_ntoa(test->dst));
 char * ret = malloc(strlen(asc_src)+strlen(asc_dst)+200);
 u_short * sport = (u_short *)test->udp_sport;
 
 /* 
  * only receive ICMP packets of the type we are currently 
  * sending
  */
 sprintf(ret, "FILTER (icmp[0]==%d) and (src host %s and dst host %s)",
 			sport[y]-1, asc_src,asc_dst);
 free(asc_src);
 free(asc_dst);			
 realloc(ret, strlen(ret)+1);
 return(ret);
}




/*
 * this function parses the icmp options in
 * the test file, and initializes the 'test' structure
 * according to what has been set
 */
struct test * icmp_parser(str, test)
 char * str;
 struct test * test;
{
 char *d = (char*)strchr(str, ':');
 if(Remote){
 	printf("ERROR ! ICMP can not be tested in remote mode -- ignoring rule\n");
	test->proto = 0;
	}
 else test->proto = IPPROTO_ICMP;
 test->num_data = 0;
 if(d)d[0]=0;
 test->icmp_type_t=(long)getpts(str,1);
 test->num_data++;
 str = d+1;
 d = (char*)strchr(str, ':');
 if(d)d[0]='\0';
 test->num_data++;
 test->icmp_code_t=(long)getpts(str,1);
 str = d+1;
 if(d)source_route_parser(test, d);
 else test->source_route = 0;
 test->soc = RawSoc;
 return(test);
}


/*
 * this function processes an incoming icmp packet and
 * stores it in the appropriate place in our global matrix
 */
void icmp_receiver(test, pkt)
 struct test * test;
 u_char * pkt;
{
 struct libnet_ip_hdr * ip = (struct libnet_ip_hdr*)pkt;
 struct libnet_icmp_hdr * icmp =(struct libnet_icmp_hdr*)(pkt+ip->ip_hl*4);
 /*
  * we don't like packets that have the offset (0,0),
  * or even (0,*) or (*,0). So we do a translation of
  * these by adding one.
  */
 matrix_set_element(Matrix,PKT_PASSED, 
   			(u_short*)test->icmp_type_t, 
   			(u_short*)test->icmp_code_t, 
   			icmp->icmp_type+1,
			icmp->icmp_code+1);
}


/*
 * this function forges an ICMP packet and sends it to the
 * the destination host. if the slave sees it, then it will
 * send it back to us
 */
int icmp_sender(test, x,y)
 struct test * test;
 int x,y;
{
 u_char * buf;
 struct libnet_ip_hdr * ip;
 u_short * sport, * dport;
 int ttl;
 if((libnet_init_packet(IP_H+ICMP_H+40, &buf))<0)
 {
  printf("Could not allocate a packet\n");
  exit(1);
 }
 ip  = (struct libnet_ip_hdr *)buf;
 sport = (u_short *)test->icmp_type_t;
 dport = (u_short *)test->icmp_code_t;
 ttl = get_ttl(test->dst);
 libnet_build_ip(ICMP_H, 0, 1234, 0, ttl, IPPROTO_ICMP,test->src.s_addr, 
 	  test->dst.s_addr, NULL, 0, buf);
 /* 
  * the 'ports' have been translated by one, so we forge the packet
  * using translated values of those ports
  */
 libnet_build_icmp_timestamp(sport[y]-1,dport[x]-1, 1234,4321,0,0,0,NULL,0, buf + IP_H);
 if(test->source_route)insert_source_route(test, buf);  
 libnet_do_checksum(buf, IPPROTO_ICMP, ICMP_H);
 libnet_write_ip(test->soc, buf, ICMP_H + ip->ip_hl*4);
 free(buf);
 return(0);
}


/*
 * displays the results of a test in a human readable
 * form, but WITHOUT the 'accept' or 'deny' keywords
 */
char * icmp_display(test,x)
 struct test * test;
 int x;
{
 char * ret = malloc(2048);
 char * asc_src = strdup(inet_ntoa(test->src));
 char * asc_dst = strdup(inet_ntoa(test->dst));
 u_short * sport = (u_short *)test->icmp_type_t;
 char * ports;
 

 /*
  * get the ports that match our policy. Note the 'translate'
  * variable of this function which has been set to -1, because
  * the ports have been translated by one in the other functions
  */
 ports = matrix_elements(Matrix,PKT_PASSED,
 			 	(u_short*)test->icmp_code_t,
				x,MatrixX,&test->policy,-1);

  
 sprintf(ret, "icmp from %s to %s type %d code %s",
 		asc_src,asc_dst, sport[x]-1,ports);
 if(test->source_route)
 {
  struct in_addr * addr = (struct in_addr*)test->source_route;
  char * r = malloc(strlen(ret)+2000);
  int i = 0;
  sprintf(r,"%s\nSource routing :\n",ret);
  free(ret);
  while(addr[i].s_addr){
  	sprintf(r, "%s\t%d. %s\n", r, i, inet_ntoa(addr[i++]));
	}
  ret = r;
  }	
 /* free(ports); */
 free(asc_src);
 free(asc_dst);
 realloc(ret, strlen(ret)+1);
 return(ret);
}		


void icmp_router_err(test, pkt, index, err,code)
 struct test * test;
 u_char * pkt;
 int index;
 int err;
{
 struct libnet_ip_hdr * ip = (struct libnet_ip_hdr *)pkt;
 struct libnet_icmp_hdr * icmp = (struct libnet_icmp_hdr*)
 				((u_char*)ip+ip->ip_hl*4);
 int sport, dport;
 

 sport = icmp->icmp_type;
 dport = icmp->icmp_code;
 if(err==3) /* ICMP UNREACH */
  matrix_set_element(Matrix, (index<<8)|(code+2),
 			(u_short*)test->icmp_type_t,
			(u_short*)test->icmp_code_t,
			sport, dport);
 else if(err==11) /* ICMP time exceed */
  matrix_set_element(Matrix, 1,
 			(u_short*)test->icmp_type_t,
			(u_short*)test->icmp_code_t,
			sport, dport);
 			
}			
