/* filterrules
 * Copyright (C) 1999 Herve Schauer Consultants and Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: inputs.c,v 1.18 1999/09/21 15:34:43 renaud Exp $
 *
 * Author : Renaud Deraison <deraison@nessus.org>
 *
 */
#include <includes.h>
#include <libnet.h>
#include "forgers.h" 
#include "inputs.h"
#include "utils.h"
#include "routers.h"
#include "matrix.h"
#include "tests.h"

extern pcap_t * Pcap;
extern int Soc;
extern int Remote;
extern struct in_addr * Routers;
matrix Matrix;
u_short MatrixX;
u_short MatrixY;
extern struct test * Test;


/*
 * Check whether the slave sent something.
 * If this is the case, then process the slave
 * input.
 *
 * Returns :
 *
 * -1 if no input
 *  0 if data arrived and was processed
 *  1 if data arrived but was corrupted
 *
 */

int
check_slave_input(forger)
 struct forgers * forger;
{
 char * buffer;
 u_char * pkt;
 fd_set rd;
 struct timeval tv = {0,100};
 FD_ZERO(&rd);
 FD_SET(Soc, &rd);
 if(select(Soc+1, &rd, NULL,NULL, &tv))
 {
 buffer = malloc(1024);
 bzero(buffer, 1024);
 if((recv(Soc, buffer, 1024, 0))<0){
 	perror("recv ");
	exit(0);
	}
 /* received something -> send a OK message */
 send(Soc, "OK\n", 3,0);
 if(!strstr(buffer, "OK\n"))
 pkt = reconstruct_packet(buffer);
 else return(1);
 free(buffer);
 /* 
  * then pass the packet to the appropriate 
  * receiver (aren't those forgers structure handy ? :)
  */
 if(pkt)forger->receiver(Test, pkt);
 return(0);
 }
 else return(-1);
}

/*
 * check if there is something interesting on
 * our link layer, such as ICMP error codes, and
 * process the data if necessary
 */
void
check_pcap_input(forger)
 struct forgers * forger;
{
 struct pcap_pkthdr head;
 const char * pkt;
 int len = 0,dl = pcap_datalink(Pcap);
 switch(dl)
 {
  case DLT_EN10MB: len = 14; break;
  case DLT_IEEE802: len = 22; break;
  case DLT_NULL: len = 4; break;
  case DLT_PPP : len = 4; break;
  case DLT_SLIP : len= 0x10;break;
  case DLT_RAW: len = 0; break;
  default : printf("Your link layer is not supported\n");
  	    exit(1);
 }
 pkt = pcap_next(Pcap, &head);
 if(pkt)
 {
  struct libnet_ip_hdr * ip = (struct libnet_ip_hdr *)(pkt+len); 
  struct libnet_icmp_hdr * icmp = (struct libnet_icmp_hdr *)(pkt+len+ip->ip_hl*4);
  struct libnet_ip_hdr * orig_ip = (struct libnet_ip_hdr *)(icmp->icmp_data);
  u_char * uci;
  int i;
  uci = (char*)orig_ip;

  i = add_router(Routers, ip->ip_src);
  forger->router_err(Test, uci, i, icmp->icmp_type, icmp->icmp_code);
  
 }
}


int check_inputs(forger)
 struct forgers * forger;
{
 int c = 0;
 /* check for the pcap first */
 check_pcap_input(forger);
 /* then listen to the slave */
 if(!Remote)if((c = check_slave_input(forger)))return(c);
 return(0);
}
