/* filterrules
 * Copyright (C) 1999 Herve Schauer Consultants and Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */ 
/*
 * $Id: ipfrag.c,v 1.9 1999/09/21 15:34:43 renaud Exp $
 *
 * Author : Renaud Deraison <deraison@nessus.org>
 *
 */
#include <includes.h>
#include <libnet.h>
#include "matrix.h"
#include "forgers.h"
#include "utils.h"
#include "tests.h"
#include "source_route.h"
#include "ttls.h"

extern int Remote;

/*
 *			IP FRAGMENTS
 *
 * The IP fragment packets are stored in our global matrix, 
 * according to their total length (Y) and their fragment 
 * offset (X).
 *
 */
 
 
extern int RawSoc;
extern int Policy;
extern matrix Matrix;
extern u_short MatrixX;


/*
 * Returns the appropriate pcap filter so that we get only the
 * packets that are of some interest to us.
 *
 */
char * ipfrag_filter(test,y)
 struct test * test;
 int y;
{
 char * asc_src = (char*)strdup(inet_ntoa(test->src));
 char * asc_dst = (char*)strdup(inet_ntoa(test->dst));
 char * ret = malloc(strlen(asc_src)+strlen(asc_dst)+200);
 u_short * sport;
 u_short a;
 sport = (u_short*)test->tcp_sport;
 a = (sport[y]+20);
 /* we only consider the packets with a given packet id */
 sprintf(ret, "FILTER (ip[2:2]==%d) and (src host %s and dst host %s)",
 			a,
			asc_src,asc_dst);
 free(asc_src);
 free(asc_dst);			
 realloc(ret, strlen(ret)+1);
 return(ret);
}


struct test * ipfrag_parser(str, test)
 char * str;
 struct test * test;
{
 char *d = (char*)strchr(str, ':');
 
 
 test->num_data = 0;
 
 if(d)d[0]=0;
 test->ipfrag_len = (long)getpts(str, 0);
 test->num_data++;
 str = d+1;
 d = (char*)strchr(str, ':');
 if(d)d[0]='\0';
 test->num_data++;
 test->ipfrag_off = (long)getpts(str, 0);
 str = d+1;
 d = strchr(str, ':');
 if(d)d[0]=0;
 
 test->proto = atoi(str);
 str = d;
 
 if(d){
       d =  strchr(d+1, ':'); 
       if(d)d[0]=0;
       source_route_parser(test, str);
       }
 else test->source_route = 0;
 test->soc = RawSoc;
 return(test);
}


/*
 * once we have received a packet which matches the
 * filter we set up, we store it in an appropriate place
 * in our matrix
 */
void ipfrag_receiver(test, pkt)
 struct test * test;
 u_char * pkt;
{
 struct libnet_ip_hdr * ip =(struct libnet_ip_hdr*)(pkt);
 matrix_set_element(Matrix,PKT_PASSED, 
   			(u_short*)test->ipfrag_len, 
   			(u_short*)test->ipfrag_off, 
   			ntohs(ip->ip_len)-20,
			ntohs(ip->ip_off)-IP_MF);
}


/*
 * Send a fragmented packet
 */
int ipfrag_sender(test, x,y)
 struct test * test;
 int x,y;
{
 
 u_short * len, * frag;
 u_char * buf;
 u_short a;
 int ttl;
 len = (u_short *)test->ipfrag_len;
 frag = (u_short *)test->ipfrag_off;
 
 
 if((libnet_init_packet(IP_H+len[y], &buf))<0)
 {
  printf("Could not allocate a packet\n");
  exit(1);
 }
 ttl = get_ttl(test->dst);
 libnet_build_ip(len[y], 0, 1234, IP_MF | frag[x], ttl,
 test->proto,test->src.s_addr, 
 	  test->dst.s_addr, NULL, 0, buf);
  if(test->source_route)insert_source_route(test, buf);  
 /*do_checksum(buf, test->proto, test-); */	  
 
 
 a = (buf[2]<<8)|buf[3];
 libnet_write_ip(test->soc, buf, len[y]+20);
 free(buf);
 return(0);
}


/* 
 * display the results of the test, according to
 * the current policy
 */
char * ipfrag_display(test,x)
 struct test * test;
 int x;
{
 char * ret = malloc(2048);
 char * asc_src = strdup(inet_ntoa(test->src));
 char * asc_dst = strdup(inet_ntoa(test->dst));
 char * ports;
 u_short * len = (u_short*)test->ipfrag_len;

 ports = matrix_elements(Matrix,PKT_PASSED,
 			 	(u_short*)test->ipfrag_off,
				x,MatrixX,&test->policy,0);
 						
 
 sprintf(ret, "ip fragmented from %s to %s [off : %s len : %d]",
 		asc_src,asc_dst, ports,len[x]);
 if(test->source_route)
 {
  struct in_addr * addr = (struct in_addr*)test->source_route;
  char * r = malloc(strlen(ret)+2000);
  int i = 0;
  sprintf(r,"%s\nSource routing :\n",ret);
  free(ret);
  while(addr[i].s_addr){
  	sprintf(r, "%s\t%d. %s\n", r, i, inet_ntoa(addr[i++]));
	}
  ret = r;
  }		
 /* free(ports); */
 free(asc_src);
 free(asc_dst);
 realloc(ret, strlen(ret)+1);
 return(ret);
}		

void ipfrag_router_err(test, pkt, index, err,code)
 struct test * test;
 u_char * pkt;
 int index;
 int err;
{
 struct libnet_ip_hdr * ip = (struct libnet_ip_hdr *)pkt;
 
 if(err==3) /* ICMP UNREACH */
  matrix_set_element(Matrix,(index<<8)|(code+2), 
   			(u_short*)test->ipfrag_len, 
   			(u_short*)test->ipfrag_off, 
   			ntohs(ip->ip_len)-20,
			ntohs(ip->ip_off)-IP_MF);
			
 else if(err==11) /* ICMP time exceed */
   matrix_set_element(Matrix, 1,
 			(u_short*)test->ipfrag_len,
			(u_short*)test->ipfrag_off,
			ntohs(ip->ip_len)-20,
			ntohs(ip->ip_off)-IP_MF);
}	

