/* filterrules
 * Copyright (C) 1999 Herve Schauer Consultants and Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * $Id: master_pcap.c,v 1.8 1999/09/21 15:34:43 renaud Exp $
 *
 * Author : Renaud Deraison <deraison@nessus.org>
 *
 */
 
 
#include <includes.h>
/*
 * This file contains functions specific to the libpcap
 */
 
 
extern char * Iface;
char * Old = NULL;;

pcap_t * init_pcap(iface)
 char * iface;
{
 pcap_t * ret;
 char errbuf[PCAP_ERRBUF_SIZE];
 if(!iface)iface = pcap_lookupdev(errbuf);
 if(!iface){
        printf("pcap_lookupdev : %s\n", errbuf);
        exit(1);
        }
 Iface = iface;
 ret = pcap_open_live(iface, 1500, 1,100,errbuf);
 if(!ret){
        printf("pcap_open_live : %s\n", errbuf);
        exit(1);
        }
 return(ret);
}

void pcap_apply_filter(pcap, filter)
 pcap_t * pcap;
 char * filter;
{
 struct bpf_program * filter_prog = malloc(sizeof(struct bpf_program));
 bpf_u_int32 netmask, network;
 if(Old)free(Old);
 Old = (char*)filter_prog;
 pcap_lookupnet(Iface, &network, &netmask, 0);
 if((pcap_compile(pcap, filter_prog, strdup(filter), 0, netmask))<0)
 {
  printf("filter compilation error\n");
  pcap_perror(pcap, "ERROR ");
  exit(1);
 }
 if((pcap_setfilter(pcap, filter_prog))<0)
 {
  printf("could not apply filter\n");
  exit(1);
 }
}
