/* filterrules
 * Copyright (C) 1999 Herve Schauer Consultants and Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: tests.c,v 1.15 1999/09/21 15:34:44 renaud Exp $
 *
 * Author : Renaud Deraison <deraison@nessus.org>
 *
 */

#include <includes.h>
#include <libnet.h>
#include "tests.h"
#include "matrix.h"
#include "utils.h"
#include "routers.h"
#include "forgers.h"
#include "inputs.h"
#include "master_pcap.h"
#include "filters.h"
matrix Matrix;
u_short MatrixX;
u_short MatrixY;
extern int Policy;
struct test * Test;
struct forgers * Forger;
extern struct in_addr * Routers;
extern int Soc;
extern int Remote;
extern char* Icmp_codes[];
static void perform_test(struct forgers *, struct test *);
 

/*
 * Parse one line of the test file, and
 * return a structure 'test' fully initialized
 * according to the rule.
 * This function will initialize our Forger global
 * variable which will then be used to actually perform
 * the test
 */	
struct test *
parse_test(str, line)
 char * str;
 int line;   /* line number */
{
 struct test  *ret = malloc(sizeof(struct test));
 char *d = (char*)strchr(str, ':');

 if(!d){
 	printf("Parse error in the tests file, line %d\n", line);
	exit(1);
	}
  d[0] = '\0';
  inet_aton(str, &(ret->src));
  str=d+1;
  d = (char*)strchr(str, ':');
  if(!d){
  	printf("Parse error in the test file, line %d\n", line);
	exit(1);
	}
 d[0]='\0';
 inet_aton(str, &(ret->dst));
 str = d+1;
 d = (char*)strchr(str, ':');
 if(d)d[0]='\0';
 Forger = forger_get(str);
 if(!Forger)
 {
  printf("protocol %s not supported\n", str);
  exit(1);
 }
 
 ret = Forger->parser(d+1, ret);
 return(ret);
}


/*
 * This is the entry point of our 
 * tests. 
 */
void
tests_main(filename)
 char * filename;
{
 FILE * f = fopen(filename, "r");
 char * buf = malloc(256);
 int line =0;
 if(!f){
 	printf("%s - file not found\n", filename);
	exit(1);
       }
    
 while(fgets(buf, 255, f))
 {
  char * c = buf;
  struct test * t;
  char * filter;
  int i = 0;
  line++;
  while((c[0]==' '))c++;
  if(c[0]=='#')continue;
  while((c[strlen(c)-1]=='\n')||(c[strlen(c)-1]=='\r'))c[strlen(c)-1]='\0';
  t = parse_test(c,line);
  if(!t->proto)continue;
  Test = t;
  Routers = init_routers_table();
  filter = Forger->local_filter(Test);
  change_filter(filter);
  /* make a new matrix for a new test */
  Matrix = new_matrix((u_short*)t->udp_dport,
	 		     (u_short*)t->udp_sport, 
			     (u_short *)&MatrixX, 
			     (u_short *)&MatrixY); 
			     
  perform_test(Forger,t);

  /* free our matrix */    			       
  for(i=0;i<MatrixY;i++)free(Matrix[i]);
	 free(Matrix);
	 free((u_short*)t->udp_dport);
	 free((u_short*)t->udp_sport);		
  
  /* don't free() the forger ! It might be useful ! */
  Forger = NULL;	     
  free(Test);
  Test = NULL;	
  free(Routers);	
 }
}
  

/*
 * do a test and send the result to the 
 * screen (no, there is no post-process of the
 * results, although it could be done)
 */
void
perform_test(forger, test)
 struct forgers * forger;
 struct test * test;
{
 u_short * y = (u_short*)test->udp_sport;
 int i;
 for(i=0;y[i];i++)
 {
  u_short * x = (u_short*)test->udp_dport;
  int j;
  char  * filter;
  char * d;
  fd_set rd;
  struct timeval tv = {5,0};
  filter = forger->filter(test, i);
  if(!Remote)
  {
   send(Soc, filter, strlen(filter), 0);
   bzero(filter, strlen(filter));
   FD_ZERO(&rd);
   FD_SET(Soc, &rd);
   select(Soc+1, &rd, NULL,NULL, &tv);
   if(FD_ISSET(Soc,&rd))recv(Soc, filter, 4,0);
  }
  /* add a protocol specific filter here (??) */
  
  for(j=0;x[j];j++)
  {
   forger->sender(test, j,i);
   check_inputs(forger);
  }
 
  if(!Remote)
  {
   while(!check_inputs(forger))usleep(100000);
   send(Soc, "STOP\n", 5,0);
   while((check_inputs(forger))<=0);
  }
  if(Policy != POL_ALL)
  {
   d = forger->display(test,i);
   printf("%s %s\n", (test->policy==POL_ACCEPT) ? "accept":"deny",d );
  }
  else
  {
   int p = POL_DENY;
   test->policy = p;
   d = forger->display(test,i);
   p = test->policy;
   printf("%s %s\n", (test->policy==POL_ACCEPT) ? "accept":"deny", forger->display(test,i));
   test->policy = POL_ACCEPT;
   d = forger->display(test,i);
   if(test->policy != p)
    printf("%s %s\n", (test->policy==POL_ACCEPT) ? "accept":"deny", forger->display(test,i));
  }
  
  
  for(j=0;Routers[j].s_addr;j++)
  {		
   int k;
   int acc = PKT_PASSED;
   for(k=2;k<17;k++)
    {
    char * ports;
    

    ports = matrix_elements(Matrix, (j<<8)|k,(u_short*)test->udp_dport,
  			i, MatrixX, &acc,forger->translate);	
    if(strcmp(ports, "0"))
    printf("\t+ %s blocked %s packets going to ports %s\n\t  Filter error : [%s]\n", 
   				inet_ntoa(Routers[j]),
				forger->asc_protocol,
				ports,
				Icmp_codes[k-2]
				);
   }
  }
 }
}
 

