/* filterrules
 * Copyright (C) 1999 Herve Schauer Consultants and Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * $Id: utils.c,v 1.10 1999/09/21 15:34:44 renaud Exp $
 *
 * Author : Renaud Deraison <deraison@nessus.org>
 *
 */

#include <includes.h>
#include "utils.h"


/*
 * getpts()
 * 
 * This function is (c) Fyodor <fyodor@dhp.com> and was taken from
 * his excellent and outstanding scanner Nmap
 * See http://www.insecure.org/nmap/ for details about 
 * Nmap
 */
 
/* Convert a string like "-100,200-1024,3000-4000,60000-" into an array 
   of port numbers*/
unsigned short *getpts(char *origexpr, int icmp) {
int exlen = strlen(origexpr);
char *p,*q;
unsigned short *tmp, *ports;
int i=0, j=0,start,end;
char *expr = (char*)strdup(origexpr);
char *mem = expr;

ports = malloc(65536 * sizeof(short));
for(;j < exlen; j++) 
  if (expr[j] != ' ') expr[i++] = expr[j]; 
expr[i] = '\0';
exlen = i;
i=0;
while((p = (char *)strchr(expr,','))) {
  *p = '\0';
  if (*expr == '-') {start = 1; end = atoi(expr+ 1)+icmp;}
  else {
    start = end = atoi(expr)+icmp;
    if ((q = (char*)strchr(expr,'-')) && *(q+1) ) end = atoi(q + 1)+icmp;
    else if (q && !*(q+1)) end = 65535;
  }
   
  if(icmp){if(start  < 0)start = 0;}
  else if(start < 1)start = 1;
  if(start > end){
  	printf("start %d, end %d\n", start, end);
	return(NULL); /* invalid spec */
	}
  for(j=start; j <= end; j++) 
    ports[i++] = j;
  expr = p + 1;
}
if (*expr == '-') {
  start = 1;
  end = atoi(expr+ 1)+icmp;
}
else {
  start = end = atoi(expr)+icmp;
  if ((q =  (char*)strchr(expr,'-')) && *(q+1) ) end = atoi(q+1)+icmp;
  else if (q && !*(q+1)) end = 65535;
}

if (start < (icmp ?0:1) || start > end) return(NULL);
for(j=start; j <= end; j++) 
  ports[i++] = j;
 
ports[i++] = 0;

tmp = realloc(ports, (i+1) * sizeof(short));
  free(mem);
  return tmp;
}


/*
 * once a packet has been received has a bunch of hex numbers, 
 * reassemble it
 */
u_char * reconstruct_packet(buffer)
 char * buffer;
{
 u_char * t = malloc(strlen(buffer));
 u_char * ret;
 int len = 0;
 
 while((buffer[strlen(buffer)-1]=='\n')||
       (buffer[strlen(buffer)-1]=='\r'))buffer[strlen(buffer)-1]=0;
       
 
 if((buffer[0]!='(')||(buffer[strlen(buffer)-1]!=')')){
 	printf("slave sent garbage\n");
	printf("%s\n", buffer);
 	return(NULL);
	}
 
 buffer+=2;

 while(buffer[0]!=')')
 {
  char *d = (char *)strchr(buffer, ' ');
  char *e;
  d[0] = 0;
  t[len]=(u_char)strtol(buffer, &e, 16);
  len++;
  buffer = d+1;
 }
 ret = malloc(len);
 memcpy(ret, t, len);
 free(t);
 return(ret);
}
 
