/*
 *  $Id: firewalk.c,v 1.2 1999/04/27 00:11:44 route Exp $
 *
 *  Firewalk
 *  firewalk implementation
 *  firewalk.c - Sets up the firewalk and calls the appropriate walking module.
 *
 *  Copyright (c) 1999 Mike D. Schiffman <mike@infonexus.com>
 *  Copyright (c) 1998 Mike D. Schiffman <mds@es2.net>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#if (HAVE_CONFIG_H)
#include "./config.h"
#endif
#include "./firewalk.h"
#include "./firepack.h"
#include "./watcher.h"
#include "./signal.h"
#include "./port_list.h"

int
firewalk_init_firepack(struct firepack **fp)
{
    *fp = (struct firepack *)malloc(sizeof(struct firepack));
    if (!(*fp))
    {
        perror("init_firepack: malloc");
        return (-1);
    }

    /*
     *  Initialize firewalking structure with defaults.
     */
    (*fp)->device                = NULL;    /* set later */
    (*fp)->ttl                   = 1;       /* initial probe IP TTL */
    (*fp)->gway_hop_cnt          = 0;       /* set later */
    (*fp)->dest_hop_cnt          = 0;       /* set later */
    (*fp)->sport                 = 53;      /* source port (TCP and UDP) */
    (*fp)->init_probe_port       = 33434;   /* ala traceroute */
    (*fp)->plist                 = NULL;    /* Linked list of ports */
    (*fp)->ports_total           = 0;
    (*fp)->ports_open            = 0;
    (*fp)->ports_unknown         = 0;
    (*fp)->protocol              = IPPROTO_UDP;
    (*fp)->red_cnt               = 1;       /* how many probes to send */
    (*fp)->red_flag              = 0;       /* Are we being redundant? */
    (*fp)->id                    = getpid();/* used to id packets */
    (*fp)->destination           = 0;       /* host we bounce replies from */
    (*fp)->gateway               = 0;       /* host we are scanning through */
    (*fp)->use_name              = 1;       /* use DNS names */
    (*fp)->bound                 = 0;       /* Unbound scan initially */
    (*fp)->sock                  = 0;       /* socket fd */
    (*fp)->quiet                 = 0;       /* quiet mode off */
    (*fp)->pcap_timeout          = REPLY_TIMEOUT;
    (*fp)->write_pause           = WRITE_PAUSE;
    memset(&(*fp)->sin, 0, sizeof(struct sockaddr_in));
    (*fp)->pd                    = NULL;    /* pcap stuff */
    (*fp)->packets_sent          = 0;
    (*fp)->packets_reply        = 0;
    (*fp)->xv                    = 1;
    (*fp)->internal_flags        = 0;
    (*fp)->output_file           = NULL;
    (*fp)->output_fd             = 0;
}


void
firewalk_reinit_firepack(struct firepack **fp)
{
    /*
     *  Reinitialize firewalking structure with defaults.
     */
    (*fp)->ttl                   = 1;
    (*fp)->gway_hop_cnt          = 0;       /* set later */
    (*fp)->dest_hop_cnt          = 0;       /* set later */
    (*fp)->bound                 = 0;       /* Unbound scan initially */
    (*fp)->packets_sent          = 0;
    (*fp)->packets_reply         = 0;
    (*fp)->ports_open            = 0;
    (*fp)->ports_unknown         = 0;
}


void
firewalk()
{
    if (catch_sig(SIGINT, catch_sigint) == -1)
    {
        perror("firewalk: cannot catch SIGINT");
        exit(EXIT_FAILURE);
    }

    firewalk_init_watcher();
    switch (fp->protocol)
    {
        case IPPROTO_TCP:
            /*
             *  We want to randomize TCP SYN numbers to obfuscate NIDS
             *  signaturing of firewalk.  Although getting a firewalk
             *  signature should not be too difficult.
             */
            libnet_seed_prand();
        case IPPROTO_UDP:
            udptcpwalk();
            break;
        case IPPROTO_ICMP:      /* UNSUP */
            break;
        default:
            fprintf(stderr, "Unknown firewalking protocol\n");
            firewalk_destroy_watcher();
            exit(EXIT_FAILURE);
    }
    firewalk_destroy_watcher();
}


/* EOF */
