/*
 *  $Id: gtk_cb.c,v 1.1.1.1 1999/04/26 22:44:53 route Exp $
 *
 *  Firewalk
 *  gtk code
 *  gtk_cb.c - gtk callback routines
 *
 *  Copyright (c) 1999 Mike D. Schiffman <mike@infonexus.com>
 *  Copyright (c) 1998 Mike D. Schiffman <mds@es2.net>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#if (HAVE_CONFIG_H)
#include "./config.h"
#endif
#include "./main.h"
#include "./firepack.h"
#include "./gtk_main.h"
#include "./gtk_cb.h"
#include "./gtk_cp.h"
#include "./gtk_pack.h"

/*
 *  This code is heavily commented for the benefit of the programmer who
 *  wants to learn GTK.  Note that there is no error checking done on any
 *  GTK calls.  None of the GTK code I've looked at (tutorial example code,
 *  GNU info documentation sample code, the example code that came with the
 *  library, and finally, several GTK-based applications) check for errors.
 *  I'm not sure why people don't check the return values of gtk_* calls,
 *  but they don't.  So I don't.
 */


void
gtk_quit_main_cb(GtkWidget *widget, gpointer data)
{
    /*
     *  Clean up after ourselves.
     */
    if (libnet_close_raw_sock(fp->sock) == -1)
    {
        perror("Cannot close the socket\n");
        exit(EXIT_FAILURE);
    }
    free_port_list(fp->plist);
    free(fp);
    gtk_main_quit();
}


void
gtk_firewalk_cb(GtkWidget *widget, gpointer data)
{
    int c;

    c = firewalk_confirm_addr(
        gtk_entry_get_text(GTK_ENTRY(gp->g_entry)),
        gtk_entry_get_text(GTK_ENTRY(gp->d_entry)));

    switch (c)
    {
        case 1:
            firewalk();
            firewalk_reinit_firepack(&fp);
            break;
        case -1:
            fire_write("Can't resolve gateway address\n");
            break;
        case -2:
            fire_write("Can't resolve destination address\n");
            break;
        case -3:
            fire_write("Can't resolve gateway or destination address\n");
            break;
        case -4:
            fire_write("Gateway and destination can't be the same.\n");
            break;
        default:
            break;
    }
}


void
gtk_cp_cb(GtkWidget *widget, gpointer data)
{
    /*
     *  Make sure only one instance of the control panel is realized at a
     *  time.
     */
    if (!(fp->internal_flags & CP_IN_USE))
    {
        fp->internal_flags |= CP_IN_USE;
        gtk_cp();
    }
}


void
gtk_quit_cp_cb(GtkWidget *widget, gpointer data)
{
    /*
     *  Release the lock.
     */
    fp->internal_flags &= ~CP_IN_USE;
    gtk_widget_destroy(widget);
}


void
gtk_set_cp_cb(GtkWidget *widget, gpointer data)
{
    fp->sport =
        gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(gp->i_port_sb));

    fp->init_probe_port =
        gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(gp->s_port_sb));

    fp->write_pause =
        gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(gp->wp_sb));

    fp->red_cnt =
        gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(gp->red_cnt_sb));

    fp->pcap_timeout =
        gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(gp->rp_sb));

    fp->ttl =
        gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(gp->ttl_sb));

    fp->xv =
        gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(gp->xv_sb));

    fp->use_name = GTK_TOGGLE_BUTTON(gp->dns_cb)->active ? TRUE : FALSE;

    fp->quiet = GTK_TOGGLE_BUTTON(gp->quiet_cb)->active ? TRUE : FALSE;

    fp->protocol =
        GTK_TOGGLE_BUTTON(gp->rb)->active ? IPPROTO_TCP : IPPROTO_UDP;

    parse_port_list(gtk_entry_get_text(GTK_ENTRY(gp->plist_entry)));
}


void
gtk_fsb_cb(GtkWidget *widget, gpointer data)
{
    if (GTK_TOGGLE_BUTTON(widget)->active) 
    {
        /*
         *  Make sure only one instance of the file select box is realized at
         *  a time.
         */
        if (!(fp->internal_flags & FSB_IN_USE))
        {
            fp->internal_flags |= FSB_IN_USE;
            gtk_do_file_box();
        }
    }
    else
    {
        fp->output_file = NULL;
    }
}  


void
gtk_quit_fsb_cb(GtkWidget *widget, gpointer data)
{
    /*
     *  Release the lock.
     */
    fp->output_file = NULL;
    fp->internal_flags &= ~FSB_IN_USE;
    gtk_widget_destroy(widget);
}


void
gtk_ok_fsb_cb(GtkWidget *widget, gpointer data)
{

    /*
     *  Open the file for output.
     */
    fp->output_fd = open(fp->output_file, O_WRONLY|O_CREAT|O_TRUNC, 0666);
    if (fp->output_fd == -1)
    {
        fprintf(stderr, "Can't open file %s\n", fp->output_file);
        fp->output_file = NULL;
    }
    /*
     *  Release the lock, destroy the widget.
     */
    fp->internal_flags &= ~FSB_IN_USE;
    gtk_widget_destroy(widget);
}

/* EOF */
