/*
 *  $Id: gtk_util.h,v 1.1.1.1 1999/04/26 22:44:54 route Exp $
 *
 *  Firewalk
 *  gtk util interface
 *
 *  Copyright (c) 1999 Mike D. Schiffman <mike@infonexus.com>
 *  Copyright (c) 1998 Mike D. Schiffman <mds@es2.net>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _GTK_UTIL_H
#define _GTK_UTIL_H

#include <gtk/gtk.h>
#include <unistd.h>

#define FSD_TYPE_INFO       0
#define FSD_TYPE_ERR        2
#define FSD_MAX_MSG_LEN     1024
#define FSD_BUTTON_OK       0
#define FSD_BUTTON_CANCEL   1


/*
 *  Display a simple textbox.
 *  This function (and supplementary callback function and symbolic constants)
 *  ripped from ethereal's simple_dialog() and then modified for my own
 *  nefarious purposes.
 *  http://ethereal.zing.org.
 */
void
gtk_text_box(
    gint,
    gchar *,
    ...
    );

void
gtk_write_tw(
    unsigned char *,
    ...
    );

void
gtk_do_spin_button(
    GtkAdjustment *,
    GtkWidget **,
    GtkWidget **,
    unsigned char *
    );


void
gtk_file_ok_sel();


void
gtk_do_file_box();

unsigned char *
get_filename();

#endif /* _GTK_UTIL_H */

/* EOF */
