/*
 *  $Id: util.c,v 1.2 1999/04/27 00:11:44 route Exp $
 *
 *  Firewalk
 *  util.c - misc routines
 *
 *  Copyright (c) 1999 Mike D. Schiffman <mike@infonexus.com>
 *  Copyright (c) 1998 Mike D. Schiffman <mds@es2.net>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#if (HAVE_CONFIG_H)
#include "./config.h"
#endif
#include <stdarg.h>
#include "./main.h"
#include "./firepack.h"
#include "./firewalk.h"
#if (HAVE_GTK)
#include "./gtk_main.h"
#include "./gtk_pack.h"
#endif

void
fire_write(u_char *msg, ...)
{
    va_list ap;
    u_char buf[BUFSIZ];

    va_start(ap, msg);
    vsnprintf(buf, sizeof(buf) - 1, msg, ap);
#if (HAVE_GTK)
    gtk_text_insert(GTK_TEXT(gp->text_window), gp->font, NULL,
        NULL, buf, -1);
#else
    printf("%s", buf);
#endif
    va_end(ap);
    if (fp->output_fd)
    {
        write(fp->output_fd, buf, strlen(buf));
    }
}


int
firewalk_confirm_addr(u_char *g, u_char *d)
{
    int c;

    c = 1;
    if ((fp->gateway = libnet_name_resolve(g, 1)) == -1)
    {
        c = -1;
    }

    if ((fp->destination = libnet_name_resolve(d, 1)) == -1)
    {
        if (c == -1)
        {
            /*
             *  Both failed.
             */
            c = -3;
        }
        else
        {
            c = -2;
        }
    }
    if (fp->destination == fp->gateway)
    {
        c = -4;
    }
    return (c);
}

void
usage(u_char *argv0)
{
    fprintf(stderr, "\nUsage : %s [options] [gateway destination]\n"
                    "\t\t   [-h] program help\n"
                    "\t\t   [-I] initial port to use for TTL ramping (%d - %d)\n"
                    "\t\t   [-i] specify alternative interface\n"
                    "\t\t   [-n] do not resolve IP addresses into hostnames\n"
                    "\t\t   [-o] write output to a file\n"
                    "\t\t   [-P] network writing pause (1 - 2000)\n"
                    "\t\t   [-p] firewalking protocol (TCP, UDP)\n"
                    "\t\t   [-q] enable quiet mode\n"
                    "\t\t   [-r] redundancy count (1 - 10)\n"
                    "\t\t   [-S] port range to scan (x - y, z)\n"
                    "\t\t   [-s] source port (%d - %d)\n"
                    "\t\t   [-T] packet reading timeout in ms (1 - 1000)\n"
                    "\t\t   [-t] IP time to live (1 - %d)\n"
                    "\t\t   [-v] program version\n"
                    "\t\t   [-x] set expire vector (1 - %d)\n"
                    "\n",
                    argv0, PORT_MIN, PORT_MAX, PORT_MIN, PORT_MAX, IP_HOP_MAX,
                    XV_MAX);
}


/* EOF */
