/*
 *  $Id: firepack.h,v 1.2 1999/04/27 00:11:44 route Exp $
 *
 *  Firewalk
 *  firepack interface
 *
 *  Copyright (c) 1999 - 2001 Mike D. Schiffman <mike@infonexus.com>
 *  Copyright (c) 1998 Mike D. Schiffman <mds@es2.net>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _FIREPACK_H
#define _FIREPACK_H

#include <unistd.h>
#include <pcap.h>
#include "./port_list.h"
#if (HAVE_GTK)
#include "./gtk_main.h"
#endif

/*
 *  Firewalk control structure.
 *  This has gotten a BIT out of control.
 */

struct firepack
{
    u_char bound;                   /* bound scan or not */
    u_char xv;                      /* expire vector */
    char *device;                   /* device to use */
    u_char *output_file;            /* output filename */
    u_char internal_flags;          /* internal flags used by the program */
    u_short ttl;                    /* starting IP TTL */
    u_short gway_hop_cnt;           /* hop count of firewall */
    u_short dest_hop_cnt;           /* hop count of destination */
    u_short sport;                  /* source port */
    u_short init_probe_port;        /* initial port used for ramping */
    u_short id;                     /* firepack packet ID */
    u_short use_name;               /* use domain names or dotted decimals */
    u_short ports_total;            /* total number of ports to be scanned */
    u_short ports_open;             /* open ports */
    u_short ports_unknown;          /* unknown ports */
    int output_fd;                  /* output file descriptor */
    int packet_offset;              /* IP packet offset */
    int protocol;                   /* firewalking protocol to use */
    int red_cnt;                    /* redundancy count */
    int red_flag;                   /* redundancy flag */ 
    int sock;                       /* socket file descriptor */
    int quiet;                      /* quiet mode */
    int pcap_timeout;               /* packet capturing timeout */
    int write_pause;                /* network writing pause */
    u_long destination;             /* ultimate destination */
    u_long gateway;                 /* gateway to probe */
    u_long packets_sent;            /* packets sent */
    u_long packets_reply;           /* packets we got replies back */
    pcap_t *pd;                     /* pcap listening structure */
    struct port_list *plist;        /* linked list of ports */
    struct sockaddr_in sin;         /* socket address structure */
};


/*
 *  Initialize the firepack structure with program defaults.
 */

int
firewalk_init_firepack(
    struct firepack **
    );


/*
 *  Reinitialize the firepack structure with program defaults.
 */

void
firewalk_reinit_firepack(
    struct firepack **
    );


#endif  /* _FIREPACK_H */

/* EOF */
