/*
 *  $Id: gtk_itemfactory.h,v 1.1.1.1 1999/04/26 22:44:54 route Exp $
 *
 *  Firewalk
 *  itemfactory interface
 *
 *  Copyright (c) 1999 - 2001 Mike D. Schiffman <mike@infonexus.com>
 *  Copyright (c) 1998 Mike D. Schiffman <mds@es2.net>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _GTK_ITEMFACTORY_H
#define _GTK_ITEMFACTORY_H

#include <gtk/gtk.h>

/*
 *  This is the GtkItemFactoryEntry structure used to generate new menus.
 *  Item 1: The menu path. The letter after the underscore indicates an
 *      accelerator key once the menu is open.
 *  Item 2: The accelerator key for the entry
 *  Item 3: The callback function.
 *  Item 4: The callback action.  This changes the parameters with
 *      which the function is called.  The default is 0.
 *  Item 5: The item type, used to define what kind of an item it is.
 *      Here are the possible values:
 *
 *      NULL               -> "<Item>"
 *      ""                 -> "<Item>"
 *      "<Title>"          -> create a title item
 *      "<Item>"           -> create a simple item
 *      "<CheckItem>"      -> create a check item
 *      "<ToggleItem>"     -> create a toggle item
 *      "<RadioItem>"      -> create a radio item
 *      <path>             -> path of a radio item to link against
 *      "<Separator>"      -> create a separator
 *      "<Branch>"         -> create an item to hold sub items
 *      "<LastBranch>"     -> create a right justified branch
 */
static GtkItemFactoryEntry menu_items[] =
{
    {"/_File",          NULL,           NULL,           0,  "<Branch>"      },
    {"/File/sep1",      NULL,           NULL,           0,  "<Separator>"   },
    {"/File/Quit",      "<control>Q",   gtk_main_quit,  0,  NULL            },
    {"/_Options",       NULL,           NULL,           0,  "<Branch>"      },
    {"/Options/_Control Panel", "<control>C", gtk_cp_cb,0,  NULL            },
    {"/_Firewalk",      "<control>F",   gtk_firewalk_cb,0,  "<Item>"        },
    {"/_Help",          NULL,           NULL,           0,  "<LastBranch>"  },
    {"/_Help/_About Firewalk", NULL, gtk_about_firewalk,0,  NULL            }
};


/*
 *  Initializes the main menu itemfactory.
 */
void
gtk_init_itemfactory(
    GtkWidget *,        /*  Pointer to the main window widget */
    GtkWidget **        /*  Pointer to the address of the menubar */
    );


#endif /* _GTK_ITEMFACTORY_H */

/* EOF */
