/*
 *  $Id: gtk_main.h,v 1.1.1.1 1999/04/26 22:44:54 route Exp $
 *
 *  Firewalk
 *  gtk main interface
 *
 *  Copyright (c) 1999 - 2001 Mike D. Schiffman <mike@infonexus.com>
 *  Copyright (c) 1998 Mike D. Schiffman <mds@es2.net>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _GTK_MAIN_H
#define _GTK_MAIN_H

#include <gtk/gtk.h>

#define WIDTH               700
#define HEIGHT              500
#define BORDER_WIDTH_0      1
#define BORDER_WIDTH_1      7
#define BORDER_WIDTH_2      5
#define ENTRY_SIZE          65
#define FW_OUTPUT_FILENAME  "firewalk.out"

/*
 *  Interface related things that need to be global.
 */
struct gtk_int_essentials
{
    GtkWidget *gateway_entry;       /* Entry box for the gateway host */
    GtkWidget *destination_entry;   /* Entry box for the destination host */
    GtkWidget *text_window;         /* Main text window */
    GdkFont *font;                  /* font we are using */
};


void
gtk_init_interface(
    int *,                /* argc */
    char ***              /* argv */
    );


void
gtk_about_firewalk();


#endif /* _GTK_MAIN_H */

/* EOF */
