/*
 *  $Id: gtk_pack.h,v 1.1.1.1 1999/04/26 22:44:54 route Exp $
 *
 *  Firewalk
 *  gtk globals interface
 *
 *  Copyright (c) 1999 - 2001 Mike D. Schiffman <mike@infonexus.com>
 *  Copyright (c) 1998 Mike D. Schiffman <mds@es2.net>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _GTK_PACK_H
#define _GTK_PACK_H

#include <gtk/gtk.h>

/*
 *  Interface related things that need to be global.
 */
struct gtkpack
{
    GtkWidget *g_entry;         /* Entry box for the gateway host */
    GtkWidget *d_entry;         /* Entry box for the destination host */
    GtkWidget *text_window;     /* Main text window */
    GdkFont *font;              /* The font we are using */
    GtkWidget *p_bar;           /* progress bar */

    /*
     *  Control Panel widgets.
     */
    GtkWidget *i_port_sb;       /* initial ramping port spin button */
    GtkWidget *red_cnt_sb;      /* redunancy count spin button */
    GtkWidget *s_port_sb;       /* source port spin button */
    GtkWidget *ttl_sb;          /* ttl spin button */
    GtkWidget *xv_sb;           /* expire vector spin button */
    GtkWidget *wp_sb;           /* write pause spin button */
    GtkWidget *rp_sb;           /* read pause spin button */
    GtkWidget *rb;              /* protocol radio button */
    GtkWidget *dns_cb;          /* DNS check button */
    GtkWidget *quiet_cb;        /* quit operation check button */
    GtkWidget *file_cb;         /* file output check button */
    GtkWidget *plist_entry;     /* port list */
};

struct gtkpack *gp;

int
gtk_init_gtkpack(
    struct gtkpack **       /* dont need to do this.. */
    );

#endif /* _GTK_PACK_H */

/* EOF */
