/*
 *  $Id: p_cap.c,v 1.1.1.1 1999/04/26 22:44:53 route Exp $
 *
 *  Firewalk
 *  p_cap implementation
 *  p_cap.c - libpcap wrapper routines
 *
 *  Copyright (c) 1999 - 2001 Mike D. Schiffman <mike@infonexus.com>
 *  Copyright (c) 1998 Mike D. Schiffman <mds@es2.net>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
 
#if (HAVE_CONFIG_H)
#include "./config.h"
#endif
#include "./p_cap.h"

pcap_t *
init_pcap_machine(int snaplen, int promisc, int to, u_char *device)
{
    pcap_t *pd;

#if (WE_HAVE_NO_DEVICE)
    /*
     *  Get the lowest numbered device that is UP, ignoring the loopback device.
     */
    if (((device) = pcap_lookupdev(errbuf)) == NULL)
    {
        pcap_err("init_pcap:", errbuf);
        return (NULL);
    }
#endif

    /*
     *  Open the packet capturing device.
     */
    if (!(pd = pcap_open_live((device), snaplen, promisc, to, errbuf)))
    {
        pcap_err("init_pcap", errbuf);
        return (NULL);
    }
    return (pd);
}


int
get_datalink_offset(pcap_t *pd)
{
    int offset_len;

    switch (pcap_datalink(pd))
    {
        case DLT_SLIP:
            offset_len = 0x10;
            break;
        case DLT_RAW:
            offset_len = 0x0;
            break;             
        case DLT_PPP:
            offset_len = 0x04;
            break;
        case DLT_EN10MB:
        default:
            offset_len = ETH_H;     /* default to ethernet */
            break;
    }
    return (offset_len);
}



void
pcap_err(u_char *module, u_char *err)
{
    fprintf(stderr, "%s: %s\n", module, err);
}


int
set_pcap_filter(pcap_t *pd, u_char *device, char *filter)
{
    struct bpf_program filter_code;
    bpf_u_int32 local_net, netmask;

    /*
     *  We need the subnet mask to apply a filter.
     */
    if (pcap_lookupnet(device, &local_net, &netmask, errbuf) == -1)
    {
        pcap_err("set_pcap_filter", errbuf);
        return (-1);
    }

    if (pcap_compile(pd, &filter_code, filter, 1, netmask) == -1)
    {
        pcap_err("set_pcap_filter", errbuf);
        return (-1);
    }

    if (pcap_setfilter(pd, &filter_code) == -1)
    {
        pcap_err("pcap_setfilter", errbuf);
        return (-1);
    }
    return (1);
}


/* EOF */
