/*
 * $Id: packet.h,v 1.1.1.1 1999/04/26 22:44:53 route Exp $
 *
 *  Firewalk
 *  packet interface
 *
 *  Copyright (c) 1999 - 2001 Mike D. Schiffman <mike@infonexus.com>
 *  Copyright (c) 1998 Mike D. Schiffman <mds@es2.net>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */


#ifndef _PACKET_H
#define _PACKET_H

#include "./p_cap.h"
#include "./firewalk.h"
#include "./firepack.h"

#if (BSDISH_OS) || (__solaris__)
#define ICMP_DEST_UNREACH  ICMP_UNREACH
#define ICMP_TIME_EXCEEDED ICMP_TIMXCEED
#define icmphdr icmp
#define type icmp_type
#define code icmp_code
#endif

extern u_char *packet;

/*
 *  Verify whether or not the ICMP packet in question is one of ours.
 */

int                         /* returns the ?_REPLY type if this is ours 
                               otherwise NO_REPLY */
icmp_verify(
    u_char *,               /* pointer to the raw pcap packet */
    struct firepack *       /* pointer to the firepack structure */
    );


/*
 *  Ok, we've got a packet we are interested in, now what do we do with it?
 *  This function proccesses the response from the host.  It only fails if
 *  we get a TTL expired message from the gateway or we reach the destination
 *  host before we hit the gateway.  Either one is fatal.
 */
 
int                         /* returns 0 if successful, -1 if not */
process_response(
    u_short *,              /* pointer to the current port */
    int                     /* packet response type */
    );


/*
 *  Print out a packets IP address.
 */

void
print_ip(
    u_char *                /* pointer to the raw pcap packet */
    );


/*
 *  Print out an ICMP packets unreachable code.
 */

u_char *
print_unreach_code(
    u_char *                /* pointer to the raw pcap packet */
    );


/*
 *  Print out packet statistics.
 */

void
p_stats();    

#endif  /* _PACKET_H */

/* EOF */
