/*
 *  $Id: port_list.h,v 1.1.1.1 1999/04/26 22:44:53 route Exp $
 *
 *  Firewalk
 *  port_list interface
 *
 *  Copyright (c) 1999 - 2001 Mike D. Schiffman <mike@infonexus.com>
 *  Copyright (c) 1998 Mike D. Schiffman <mds@es2.net>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _PORT_LIST_H
#define _PORT_LIST_H

#define DEFAULT_PORT_LIST   "11-139,6000-6010"

struct port_list
{
    u_short node;           /* node number */
    u_short bport;          /* beggining port */
    u_short eport;          /* terminating port */
    struct port_list *next; /* next node in the list */
};

extern struct firepack *fp;

/* 
 *  Run through the port list and build the linked list.  If there is one
 *  illegal token in the list, it fails.  I should make this more fault
 *  tolerant I suppose.
 */

int                     /* 1 if nodes were allocated, -1 otherwise */
parse_port_list(
    char *              /* Pointer to the list of ports */
    );


/* 
 *  Dump the port list.
 */

void
dump_port_list(
    struct port_list *  /* Pointer to the port list head node */
    );


/* 
 *  Dump the port list.
 */

u_char *                /* stringie */
dump_port_list_as_string(
    struct port_list *  /* Pointer to the port list head node */
    );


/* 
 *  Free all nodes and return the heap memory.
 */

void
free_port_list(
    struct port_list *  /* Pointer to the port list head node */
    );


/*
 *  Grabs the next port range from the port list.  Uses a static counter to
 *  keep track of where it is in the list.
 */

int                     /* 1 while there are more nodes, 0 when we're done */
get_next_port_pair(
    struct port_list *, /* Pointer to the port list head node */
    u_short *,          /* Pointer to the begining port */
    u_short *           /* Pointer to the end port */
    );

#endif  /* _PORT_LIST_H */

/* EOF */
