#ifndef FWRD_H
#define FWRD_H

#include<libnet.h>
#include<arpa/inet.h>
#include<time.h>

typedef struct
{
	struct in_addr ip;
	u_int16_t port;
} fwrd_elt;

typedef struct
{
	u_int32_t ip;		// IP address
	u_char ea[ETH_ALEN];	// ethernet address
} arp_elt;

#define TIMEVAL_MSEC_DIFF(a, b) ((((a).tv_sec-(b).tv_sec)*1000)+(((a).tv_usec-(b).tv_usec)/1000))

typedef struct 
{
	u_int32_t ip; 	// src_ip GPS used
	u_int16_t port;	// dst_port
	int seq;	// seq nb
	int nbretries;	// nb of retries
	struct timeval tv; // sending date
	int gotcha;	// indicates if we have the packet
	int wait;	// indicatates if the packet is queued
} port_elt;

typedef struct
{
	int i;
	struct timeval tv;
} sock_elt;


#endif
