#include<stdio.h>
#include<ctype.h>
#include<time.h>
#include<netinet/if_ether.h>
#include<arpa/inet.h>
#include<libnet.h>
#include<pcap.h>
#include "pcap-int.h"
#include "gateway.h"
#include "gps.h"

int ahtoi(char *ptr)
{
	int i=0;

	if(isalpha(*ptr)) i+=(*ptr-'A'+10)*16;
	else i+=(*ptr-'0')*16;
	ptr++;
	if(isalpha(*ptr)) i+=(*ptr-'A'+10);
	else i+=(*ptr-'0');

	return(i);
}

int power(int i, int j)
{
	int k, l=1;
	for(k=0; k<j; k++) l*=i;
	return(l);
}

//!\\ no file input error handling
u_int32_t get_gateway_ip(char *fn_route)
{
	int i;
	u_int32_t ip;
	char buffer[256], interface[16], dest[9], gateway[9], flags[5], refcnt[10], use[10], metric[10], mask[9], mtu[10], window[10], irtt[10];
	FILE *froute=fopen(fn_route, "rt");
	if(!froute) { fprintf(stderr, "fopen: not able to open %s\n", fn_route); exit(-1); }
	for(i=0; i<11; i++) fscanf(froute, "%s", buffer);
	while(fscanf(froute, "%s %s %s %s %s %s %s %s %s %s %s\n", interface, dest, gateway, flags, refcnt, use, metric, mask, mtu, window, irtt)!=EOF)
	{
		ip=0;
		for(i=0; i<4; i++) ip+=power(256, i)*ahtoi(gateway+(2*i));
		if((ip=ntohl(ip))) { fclose(froute); return(ip); }
	}
	fclose(froute);
	return(-1);
}

//!\\ no file input error handling
// this function reads the ARP cache and return the MAC address which corresponds to IP
int get_mac(char *fn_arp, u_int32_t ip, u_char *mac, char *dev)
{
	char buffer[BUFSIZ], str_ip[16], hwtype[10], flags[10], current_mac[18], mask[18], device[32];
	int i;
	u_int32_t current_ip;
	FILE *farp=fopen(fn_arp, "rt");
	if(!farp) { fprintf(stderr, "fopen: not able to open %s\n", fn_arp); exit(-1); }
	for(i=0; i<9; i++) fscanf(farp, "%s", buffer);
	while(fscanf(farp, "%s %s %s %s %s %s\n", str_ip, hwtype, flags, current_mac, mask, device)!=EOF)
	{
		str_ip[15]='\0';
		if((current_ip=libnet_name_resolve(str_ip, LIBNET_RESOLVE))==-1)
			libnet_error(LIBNET_ERR_WARNING, "libnet_name_resolve failed while reading the ARP cache\n");
		if(current_ip==ip && !strcmp(dev, device))
		{
			for(i=0; i<ETH_ALEN; i++) mac[i]=ahtoi(current_mac+(3*i));
			fclose(farp);
			return(0);
		}
	}
	fclose(farp);
	return(-1);
}

int send_ARP_request(char *dev, u_int32_t *src_ip, u_int32_t *dst_ip, u_char *src_mac, u_char *dst_mac)
{
	struct libnet_link_int *interface;
	struct pcap *descr;
	struct pcap_pkthdr phdr;
	struct timeval tv, current;
	struct ether_header *ehdr;
	struct ether_arp *ahdr;
	char errbuf[GPS_ERRBUF_SIZE];
	const u_char *sniffed_packet;
	u_char *packet, null_mac[ETH_ALEN], broadcast_mac[ETH_ALEN];
	int nbretries=0, i;

	for(i=0; i<ETH_ALEN; i++)
	{
		null_mac[i]=0;
		broadcast_mac[i]=255;
	}

	libnet_init_packet(LIBNET_ETH_H+LIBNET_ARP_H, &packet);
	if(!packet) error(NULL, -2);

	if(!(interface=libnet_open_link_interface(dev, errbuf)))
		libnet_error(LIBNET_ERR_FATAL, "libnet_open_link_interface failed (%s)\n", errbuf);
	if(!(descr=pcap_open_live(dev, 65536, 1, -1, errbuf)))
		libnet_error(LIBNET_ERR_FATAL, "pcap_open_live: %s\n", errbuf);
	unblock_socket(descr->fd);

#ifdef ARPHRD_ETHER // I think it should be ARPHDR_ETHER
	if(libnet_build_arp(ARPHRD_ETHER, ETHERTYPE_IP, ETH_ALEN, 4, ARPOP_REQUEST, src_mac, (u_char *)src_ip, null_mac, (u_char *)dst_ip, NULL, 0, packet+LIBNET_ETH_H)==-1)
		libnet_error(LIBNET_ERR_FATAL, "libnet_build_arp failed\n");
#else
	if(libnet_build_arp(ARPHDR_ETHER, ETHERTYPE_ARP, ETH_ALEN, 4, ARPOP_REQUEST, src_mac, (u_char *)src_ip, null_mac, (u_char *)dst_ip, NULL, 0, packet+LIBNET_ETH_H)==-1)
		libnet_error(LIBNET_ERR_FATAL, "libnet_build_arp failed\n");
#endif
	if(libnet_build_ethernet(broadcast_mac, src_mac, ETHERTYPE_ARP, NULL, 0, packet)==-1)
		libnet_error(LIBNET_ERR_FATAL, "libnet_build_ethernet failed\n");

	i=0; while(libnet_write_link_layer(interface, dev, packet, LIBNET_ETH_H+LIBNET_ARP_H)==-1 && i++<3);
	if(nbretries>2) libnet_error(LIBNET_ERR_FATAL, "libnet_write_link_layer failed\n");
	gettimeofday(&tv, NULL);

	do
	{
		if((sniffed_packet=pcap_next(descr, &phdr)))
		{
			ehdr=(struct ether_header *)sniffed_packet;
			if(ntohs(ehdr->ether_type)==ETHERTYPE_ARP)
			{
				ahdr=(struct ether_arp *)((u_char *)ehdr+ETHER_HDR_LEN);
				if(ntohs(ahdr->ea_hdr.ar_op)==ARPOP_REPLY && *(u_int32_t *)ahdr->arp_spa==*dst_ip)
				{
					for(i=0; i<ETH_ALEN; i++) dst_mac[i]=ahdr->arp_sha[i];
					pcap_close(descr);
					if(libnet_close_link_interface(interface)==-1)
						libnet_error(LIBNET_ERR_WARNING, "libnet_close_link_interface faild\n");
					libnet_destroy_packet(&packet);
					return(0);
				}
			}
		}
		gettimeofday(&current, NULL);
		if(TIMEVAL_MSEC_DIFF(current, tv)>ARP_TIMEOUT)
		{
			i=0; while(libnet_write_link_layer(interface, dev, packet, LIBNET_ETH_H+LIBNET_ARP_H)==-1 && i++<3);
			tv=current;
			nbretries++;
		}		
	} while(nbretries<5);

	pcap_close(descr);
	if(libnet_close_link_interface(interface)==-1)
		libnet_error(LIBNET_ERR_WARNING, "libnet_close_link_interface failed\n");
	libnet_destroy_packet(&packet);
	return(-1);
}

