#include<stdlib.h>

#include "fwrd.h"

void init_fwrd_elt(fwrd_elt *elt, u_int32_t ip)
{
	elt->ip=ip;
	elt->nb_ports=0;
	elt->port_list=NULL;
}

void add_fwrd_port(fwrd_elt *elt, u_int16_t port)
{
	fwrd_port *ptr1, *ptr2, *new;

	if(!elt->port_list) // the list is empty
	{
		if(!(elt->port_list=(fwrd_port *)malloc(sizeof(fwrd_port)))) error(NULL, -2);
		elt->port_list->port=port;
		elt->port_list->next=NULL;
		elt->nb_ports++;
	}
	else
	{
		for(ptr1=ptr2=elt->port_list; ptr1->port<port && ptr1->next; ptr2=ptr1, ptr1=ptr1->next);

		if(ptr1->port==port) return; // we already have this port

		if(!(new=(fwrd_port *)malloc(sizeof(fwrd_port)))) error(NULL, -2);
		new->port=port;

		elt->nb_ports++;

		if(ptr1==ptr2)
		{
			if(!ptr1->next && ptr1->port<port) // only one port in the list
			{
				new->next=NULL;
				ptr1->next=new;
			}
			else // insert at the begining of list
			{
				new->next=ptr1;
				elt->port_list=new;
			}
		}
		else if(!ptr1->next) // end of list reached
		{
			if(ptr1->port<port) // add at end of list
			{
				new->next=NULL;
				ptr1->next=new;
			}
			else // insert before the end of list
			{
				new->next=ptr1;
				ptr2->next=new;
			}
		}
		else
		{
			new->next=ptr1;
			ptr2->next=new;
		}
	}
}

void free_fwrd_port_list(fwrd_elt *elt)
{
	fwrd_port *ptr1, *ptr2;
	for(ptr1=elt->port_list; ptr1; ptr1=ptr2)
	{
		ptr2=ptr1->next;
		free(ptr1);
	}
	elt->port_list=NULL;
	elt->nb_ports=0;
}

// return 0 if we have the port, -1 if not
int search_fwrd_port(fwrd_elt *elt, u_int16_t port)
{
	fwrd_port *ptr;

	if(!elt->port_list) return(-1);
	for(ptr=elt->port_list; ptr->port<port && ptr->next; ptr=ptr->next);
	if((!ptr->next && ptr->port==port) || ptr->port==port) return(0);
	else return(-1);
}

void fwrd_print_port_list(fwrd_elt *elt, char *format)
{
	fwrd_port *ptr;
	for(ptr=elt->port_list; ptr; ptr=ptr->next)
		fprintf(stdout, format, ptr->port);
}

void fwrd_print_reverse_port_list(fwrd_elt *elt, char *format, port_elt *tab_port, int nbports)
{
	fwrd_port *ptr;
	int i;

	for(i=0, ptr=elt->port_list; ptr && i<nbports; i++)
	{
		if(tab_port[i].port<ptr->port)
			fprintf(stdout, format, tab_port[i].port);
		else ptr=ptr->next;
	}
	for(; i<nbports; i++)
		fprintf(stdout, format, tab_port[i].port);
}

