#ifndef FWRD_H
#define FWRD_H

#include<sys/types.h>
#include "gps.h"

typedef struct st_fwrd_port
{
	struct st_fwrd_port *next;
	u_int16_t port;
} fwrd_port;

typedef struct
{
	u_int32_t ip;
	fwrd_port *port_list;
	u_int16_t nb_ports;
} fwrd_elt;


void init_fwrd_elt(fwrd_elt *elt, u_int32_t ip);
void add_fwrd_port(fwrd_elt *elt, u_int16_t port);
void free_fwrd_port_list(fwrd_elt *elt);
int  search_fwrd_port(fwrd_elt *elt, u_int16_t port);
void fwrd_print_port_list(fwrd_elt *elt, char *format);
void fwrd_print_reverse_port_list(fwrd_elt *elt, char *format, port_elt *tab_port, int nbports);

#endif
