#include<stdio.h>
#include<ctype.h>
#include<sys/socket.h>
#include<net/if_arp.h>
#include<string.h>
#include<time.h>
#include<netinet/if_ether.h>
#include<arpa/inet.h>
#include<libnet.h>
#include<pcap.h>
#include "pcap-int.h"
#include "mac-arp.h"
#include "gps.h"

int ahtoi(char *ptr)
{
	int i=0;

	if(isalpha(*ptr)) i+=(*ptr-'A'+10)*16;
	else i+=(*ptr-'0')*16;
	ptr++;
	if(isalpha(*ptr)) i+=(*ptr-'A'+10);
	else i+=(*ptr-'0');

	return(i);
}

int power(int i, int j)
{
	int k, l=1;
	for(k=0; k<j; k++) l*=i;
	return(l);
}

//!\\ no file input error handling
u_int32_t get_gateway_ip(char *fn_route)
{
	int i;
	u_int32_t ip;
	char buffer[256], interface[16], dest[9], gateway[9], flags[5], refcnt[10], use[10], metric[10], mask[9], mtu[10], window[10], irtt[10];
	FILE *froute=fopen(fn_route, "rt");
	if(!froute) { fprintf(stderr, "fopen: not able to open %s\n", fn_route); exit(-1); }
	for(i=0; i<11; i++) fscanf(froute, "%s", buffer);
	while(fscanf(froute, "%s %s %s %s %s %s %s %s %s %s %s\n", interface, dest, gateway, flags, refcnt, use, metric, mask, mtu, window, irtt)!=EOF)
	{
		ip=0;
		for(i=0; i<4; i++) ip+=power(256, i)*ahtoi(gateway+(2*i));
		if((ip=ntohl(ip))) { fclose(froute); return(ip); }
	}
	fclose(froute);
	return(-1);
}

int send_ARP_request(char *dev, u_int32_t *srcip, u_int32_t *dstip, u_char *src_mac, u_char *dst_mac)
{
	struct libnet_link_int *interface;
	struct pcap *pdescr;
	struct pcap_pkthdr phdr;
	struct timeval tv, current;
	struct ether_header *ehdr;
	struct ether_arp *ahdr;
	char ebuf[GPS_ERRBUF_SIZE];
	const u_char *sniffed_packet;
	u_char *packet, null_mac[ETH_ALEN], broadcast_mac[ETH_ALEN];
	int nbretries=0, i;

	for(i=0; i<ETH_ALEN; i++)
	{
		null_mac[i]=0;
		broadcast_mac[i]=255;
	}

	libnet_init_packet(LIBNET_ETH_H+LIBNET_ARP_H, &packet);
	if(!packet) error(NULL, -2);

	if(!(interface=libnet_open_link_interface(dev, ebuf)))
		libnet_error(LIBNET_ERR_FATAL, "libnet_open_link_interface failed (%s)\n", ebuf);
	if(!(pdescr=pcap_open_live(dev, 65536, 1, -1, ebuf)))
		libnet_error(LIBNET_ERR_FATAL, "pcap_open_live: %s\n", ebuf);
	unblock_socket(pdescr->fd);

#ifdef ARPHRD_ETHER // I think it should be ARPHDR_ETHER
	if(libnet_build_arp(ARPHRD_ETHER, ETHERTYPE_IP, ETH_ALEN, 4, ARPOP_REQUEST, src_mac, (u_char *)srcip, null_mac, (u_char *)dstip, NULL, 0, packet+LIBNET_ETH_H)==-1)
		libnet_error(LIBNET_ERR_FATAL, "libnet_build_arp failed\n");
#else
	if(libnet_build_arp(ARPHDR_ETHER, ETHERTYPE_ARP, ETH_ALEN, 4, ARPOP_REQUEST, src_mac, (u_char *)srcip, null_mac, (u_char *)dstip, NULL, 0, packet+LIBNET_ETH_H)==-1)
		libnet_error(LIBNET_ERR_FATAL, "libnet_build_arp failed\n");
#endif
	if(libnet_build_ethernet(broadcast_mac, src_mac, ETHERTYPE_ARP, NULL, 0, packet)==-1)
		libnet_error(LIBNET_ERR_FATAL, "libnet_build_ethernet failed\n");

	i=0; while(libnet_write_link_layer(interface, dev, packet, LIBNET_ETH_H+LIBNET_ARP_H)==-1 && i++<3);
	if(nbretries>2) libnet_error(LIBNET_ERR_FATAL, "libnet_write_link_layer failed\n");
	gettimeofday(&tv, NULL);

	do
	{
		if((sniffed_packet=pcap_next(pdescr, &phdr)))
		{
			ehdr=(struct ether_header *)sniffed_packet;
			if(ntohs(ehdr->ether_type)==ETHERTYPE_ARP)
			{
				ahdr=(struct ether_arp *)((u_char *)ehdr+ETHER_HDR_LEN);
				if(ntohs(ahdr->ea_hdr.ar_op)==ARPOP_REPLY && *(u_int32_t *)ahdr->arp_spa==*dstip)
				{
					for(i=0; i<ETH_ALEN; i++) dst_mac[i]=ahdr->arp_sha[i];
					pcap_close(pdescr);
					if(libnet_close_link_interface(interface)==-1)
						libnet_error(LIBNET_ERR_WARNING, "libnet_close_link_interface faild\n");
					libnet_destroy_packet(&packet);
					return(0);
				}
			}
		}
		gettimeofday(&current, NULL);
		if(TIMEVAL_MSEC_DIFF(current, tv)>ARP_TIMEOUT)
		{
			i=0; while(libnet_write_link_layer(interface, dev, packet, LIBNET_ETH_H+LIBNET_ARP_H)==-1 && i++<3);
			tv=current;
			nbretries++;
		}		
	} while(nbretries<5);

	pcap_close(pdescr);
	if(libnet_close_link_interface(interface)==-1)
		libnet_error(LIBNET_ERR_WARNING, "libnet_close_link_interface failed\n");
	libnet_destroy_packet(&packet);
	return(-1);
}

int get_mac(u_int32_t ip, char *mac, char *dev)
{
	my_arpreq arpr;
	int sd;

	if((sd=socket(AF_INET, SOCK_DGRAM, 0))<0) return(-1);
	arpr.arp_pa.sin_family=AF_INET;
	arpr.arp_pa.sin_addr.s_addr=ip;
	arpr.arp_flags=0;
	strncpy(arpr.arp_dev, dev, 15);
	arpr.arp_dev[15]='\0';
	if(ioctl(sd, SIOCGARP, &arpr)) return(-1);
	close(sd);
	memcpy(mac, arpr.arp_ha.sa_data, ETH_ALEN);
	return(0);
}

