#include<netinet/in.h>
#include<sys/ioctl.h>
#include<sys/socket.h>
#include<libnet.h>
#include<stdio.h>
#include<stdlib.h>
#include<string.h>

#include "route.h"

/*
 * Note that SIOCGIFxxxx calls
 * produce weird results. I had
 * to create a suitable structure
 * (my_ifreq) to have them working.
 */
devlist *get_localdevs()
{
	struct ifconf ifc;
	my_ifreq ifr_nm, *ifr;
	int sd, i;
	char buffer[10240]; /* weird size ? -- taken from nmap */
	static devlist localdevs;

	localdevs.nb=0;
	localdevs.dev_list=NULL;
/*
 *	realloc() seems to not need a previously allocated block
 *	uncomment this if you have trouble with realloc()
 *
	if(!(localdevs.dev_list=(netdev *)malloc(sizeof(netdev))))
		{ fprintf(stderr, "malloc: memory allocation failed\n"); return(NULL); }
*/

	if((sd=socket(AF_INET, SOCK_DGRAM, 0))<0) 
		{ fprintf(stderr, "socket: can't open a socket\n"); return(NULL); }

	ifc.ifc_len=sizeof(buffer);
	ifc.ifc_ifcu.ifcu_buf=buffer;
	// get devices and their addresses
	if(ioctl(sd, SIOCGIFCONF, &ifc)<0)
		{ fprintf(stderr, "ioctl: can't get the network interface list\n"); close(sd); return(NULL); }

	if(!ifc.ifc_len)
		{ fprintf(stderr, "According to SIOCGIFCONF, you don't have any network interface\n"); close(sd); return(NULL); }

	for(ifr=(my_ifreq *)buffer; ifr && *(char *)ifr && (char *)ifr<buffer+ifc.ifc_len; ifr++)
	{
		if(!ifr->ifr_ifrn.ifrn_name[0]) continue;
		if(!(localdevs.dev_list=(netdev *)realloc(localdevs.dev_list, (localdevs.nb+1)*sizeof(netdev))))
			{ fprintf(stderr, "realloc: memory reallocation failed\n"); close(sd); return(NULL); }
		strncpy(localdevs.dev_list[localdevs.nb].name, ifr->ifr_ifrn.ifrn_name, IFNAMSIZ);
		localdevs.dev_list[localdevs.nb].name[IFNAMSIZ-1]='\0';
		localdevs.dev_list[localdevs.nb].ip=ifr->ifr_ifru.ifru_addr.sin_addr.s_addr;
		localdevs.dev_list[localdevs.nb++].netmask=ifr->ifr_ifru.ifru_netmask.sin_addr.s_addr;
	}
	// get netmasks
	for(i=0; i<localdevs.nb; i++)
	{
		bzero(&ifr_nm, sizeof(struct ifreq));
		ifr_nm.ifr_netmask.sin_family=AF_INET;
		strncpy(ifr_nm.ifr_name, localdevs.dev_list[i].name, IFNAMSIZ);
		if(ioctl(sd, SIOCGIFNETMASK, (char *)&ifr_nm)<0)
			{ fprintf(stderr, "ioctl: can't get a netmask\n"); close(sd); return(NULL); }
		localdevs.dev_list[i].netmask=ifr_nm.ifr_netmask.sin_addr.s_addr;
	}
	close(sd);
	return(&localdevs);
}

void free_devlist(devlist *dl)
{
	free(dl->dev_list);
}

int islocalhost(devlist *dl, u_int32_t ip)
{
	int i;
	for(i=0; i<dl->nb; i++)
		if(ip==dl->dev_list[i].ip)
			return(1);
	return(0);
}

netdev *get_suitable_dev(devlist *dl, u_int32_t target_ip)
{
	int i;
	for(i=0; i<dl->nb; i++)
		if((dl->dev_list[i].ip & dl->dev_list[i].netmask)==(target_ip & dl->dev_list[i].netmask))
			return(&dl->dev_list[i]);
	return(NULL);
}

