#ifndef GPS_H
#define GPS_H

#include<libnet.h>
#include<pcap.h>
#include<sys/types.h>
#include<time.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef VERSION
#define GPS_VERSION VERSION
#else
#define GPS_VERSION "0.8.1"
#endif


// NULL flag
#define TH_NULL 0

// spoofing options
#define MAC_SPOOF 1
#define IP_SPOOF  0

// scan types
#define SYN_SCAN  TH_SYN
#define FIN_SCAN  TH_FIN
#define ACK_SCAN  TH_ACK
#define XMAS_SCAN TH_FIN|TH_URG|TH_PUSH
#define NULL_SCAN TH_NULL
#define RAND_SCAN -1
#define FWRD_SCAN -2

// frag options
#define NO_FRAG		0
#define TINY_FRAG	1
#define OVERLAP_FRAG	2

// redefines
#define GPS_PACKET (LIBNET_PACKET)
#define GPS_ERRBUF_SIZE (LIBNET_ERRBUF_SIZE<PCAP_ERRBUF_SIZE) ? PCAP_ERRBUF_SIZE : LIBNET_ERRBUF_SIZE
#define GPS_ETH_H (LIBNET_ETH_H)
#define GPS_IP_H  (LIBNET_IP_H)
#define GPS_TCP_H (LIBNET_TCP_H)
#define GPS_TRAME (GPS_ETH_H+GPS_IP_H+GPS_TCP_H)
#define GPS_ETH_ALEN (ETHER_ADDR_LEN)

#define TIMEVAL_MSEC_DIFF(a, b) ((((a).tv_sec-(b).tv_sec)*1000)+(((a).tv_usec-(b).tv_usec)/1000))


typedef struct
{
	u_int32_t ip;			// IP address
	u_char ea[GPS_ETH_ALEN];	// ethernet address
} arp_elt;

typedef struct 
{
	u_int32_t ip;		// src_ip GPS uses
	u_int16_t port;		// dst_port
	u_int16_t src_port;	// src_port
	int seq;		// seq nb
	int ack;		// ack nb
	int nbretries;		// nb of retries
	struct timeval tv;	// sending date
	int gotcha;		// indicates if we have the packet
	int wait;		// indicatates if the packet is queued
	u_int16_t ip_id;	// IP ID
} port_elt;

typedef struct
{
	int i;
	struct timeval tv;
} sock_elt;


// functions:
// be careful, several of them are usable only in gps.c
void get_ea(char *ea, int rs);
void init_port(int i, u_int16_t port);
int  search_port(u_int16_t port);
void reverse_scan_disp();
int  search_src_ip(u_int32_t ip);
void unblock_socket(int fd);
void randomize_port_order(u_int16_t *tab_switch_o2r, u_int16_t *tab_switch_r2o);
void ip_packet_generator(int scan_speed);
void ethernet_packet_generator(int scan_speed);
void usage(char *cmd);
void error(char *msg, int ret);


#endif
