#ifndef ROUTE_H
#define ROUTE_H

#include<net/if.h>
#include "gps.h"

#define DELIM " \t\n"
#define FROUTE "/proc/net/route"

typedef struct {
	u_int32_t ip;
	u_int32_t netmask;
	char name[IFNAMSIZ];
} netdev;

typedef struct {
	int nb;
	netdev *dev_list;
} devlist;

typedef struct {
	char ifname[IFNAMSIZ];
	u_int32_t gateway;
} route_elt;

/*
 * I created this structure to replace struct ifreq.
 * I tested SIOCGIFCONF calls on some linux flavors,
 * and the result was the same: the ip addresses of
 * ifr_ifru are 'offseted' of 2 bytes.
 * Using    struct    sockaddr_in    instead    of
 * struct  sockaddr  seems  to  solve  the  problem.
 * If you have  trouble  with this,  please mail me
 * (whitehat@altern.org).   You  may  try  to   use
 * struct ifreq instead of my_ifreq in route.c.
 */
typedef struct
{
	union
	{
		char ifrn_name[IFNAMSIZ];
	} ifr_ifrn;

	union
	{
		struct sockaddr_in ifru_addr;
		struct sockaddr_in ifru_dstaddr;
		struct sockaddr_in ifru_broadaddr;
		struct sockaddr_in ifru_netmask;
		struct sockaddr_in ifru_hwaddr;
		short int ifru_flags;
		int ifru_ivalue;
		int ifru_mtu;
		struct ifmap ifru_map;
		char ifru_slave[IFNAMSIZ];
		__caddr_t ifru_data;
	} ifr_ifru;
} my_ifreq;


// functions
devlist *get_localdevs();
void free_devlist(devlist *dl);
int islocalhost(devlist *dl, u_int32_t ip);
netdev *get_suitable_dev(devlist *dl, u_int32_t target_ip);
u_int32_t get_gateway_ip(u_int32_t dstip);
route_elt *get_route(u_int32_t dstip);

#endif
