#include<libnet.h>
#include<pcap.h>
#include "pcap-int.h"

#include "timeout.h"
#include "gps.h"


int ethernet_eval_timeout(char *dev, int rseed, int verbose, u_int32_t srcip, u_int32_t dstip, u_int16_t pingport, u_char *src_mac, u_char *dst_mac)
{
	struct pcap *pdescr;
	struct pcap_pkthdr phdr;
	struct libnet_link_int *interface;
	struct libnet_ethernet_hdr *ehdr;
	struct libnet_arp_hdr *ahdr, duplic;
	struct libnet_ip_hdr *ihdr;
	struct libnet_tcp_hdr *thdr;
	char ebuf[GPS_ERRBUF_SIZE];
	const u_char *packet;
	u_char *my_packet;
	int timeout=0, i, send=1, nb_responses=0, nbretries=0;
	struct timeval tv1, tv2;

	if(!(interface=libnet_open_link_interface(dev, ebuf)))
		libnet_error(LIBNET_ERR_FATAL, "libnet_open_link_int failed (%s)\n", ebuf);
	if(!(pdescr=pcap_open_live(dev, 65536, 1, -1, ebuf)))
		libnet_error(LIBNET_ERR_FATAL, "pcap_open_live failed (%s)\n", ebuf);
	unblock_socket(pdescr->fd);

	if(!(my_packet=(u_char *)malloc(GPS_TRAME))) error(NULL, -2);

	do
	{
		if(send)
		{
			libnet_build_tcp(libnet_get_prand(rseed)+1024, pingport, 65535*libnet_get_prand(rseed)*libnet_get_prand(rseed), 65535*libnet_get_prand(rseed)*libnet_get_prand(rseed), TH_ACK, 1024, 0, NULL, 0, my_packet+GPS_ETH_H+GPS_IP_H);
			libnet_build_ip(GPS_TCP_H, IPTOS_LOWDELAY, libnet_get_prand(rseed)*libnet_get_prand(rseed), 0, 255, IPPROTO_TCP, srcip, dstip, NULL, 0, my_packet+GPS_ETH_H);
			libnet_build_ethernet(dst_mac, src_mac, ETHERTYPE_IP, NULL, 0, my_packet);
			if(libnet_do_checksum(my_packet+GPS_ETH_H, IPPROTO_TCP, GPS_TCP_H)==-1 || libnet_do_checksum(my_packet+GPS_ETH_H, IPPROTO_IP, GPS_IP_H)==-1)
				libnet_error(LIBNET_ERR_FATAL, "libnet_do_checksum failed\n");
			i=0; while(libnet_write_link_layer(interface, dev, my_packet, GPS_TRAME)==-1 && i++<3);
			if(i<3)
			{
				send=0;
				gettimeofday(&tv2, NULL);
			}
			else
			{
				libnet_error(LIBNET_ERR_WARNING, "libnet_write_link_layer failed\n");
				continue;
			}
		}
		if((packet=(u_char *)pcap_next(pdescr, &phdr)))
		{
			ehdr=(struct libnet_ethernet_hdr *)packet;
			switch(ntohs(ehdr->ether_type))
			{
				case ETHERTYPE_ARP:
					ahdr=(struct libnet_arp_hdr *)((u_char *)ehdr+ETHER_HDR_LEN);
					if(ntohs(ahdr->ar_op)!=ARPOP_REQUEST) break;
					if(*(u_int32_t *)ahdr->ar_tpa!=srcip) break;
					duplic=*ahdr;
					ahdr->ar_op=ntohs(ARPOP_REPLY);
					for(i=0; i<GPS_ETH_ALEN; i++)
					{
						ahdr->ar_sha[i]=ehdr->ether_shost[i]=src_mac[i];
						ahdr->ar_tha[i]=ehdr->ether_dhost[i]=duplic.ar_sha[i];
					}
					for(i=0; i<4; i++)
					{
						ahdr->ar_spa[i]=duplic.ar_tpa[i];
						ahdr->ar_tpa[i]=duplic.ar_spa[i];
					}
					if(libnet_write_link_layer(interface, dev, (u_char *)packet, ETHER_HDR_LEN+sizeof(struct libnet_arp_hdr))==-1)
						libnet_error(LIBNET_ERR_WARNING, "libnet_write_link_layer failed\n");
					break;
				case ETHERTYPE_IP:
					ihdr=(struct libnet_ip_hdr *)((u_char *)ehdr+ETHER_HDR_LEN);
					if(ihdr->ip_src.s_addr!=dstip || ihdr->ip_dst.s_addr!=srcip || ihdr->ip_p!=IPPROTO_TCP || (ihdr->ip_off & ~ntohs(IP_DF))) break;
					thdr=(struct libnet_tcp_hdr *)((u_char *)ihdr+4*ihdr->ip_hl);
					if(!(thdr->th_flags & TH_RST) || ntohs(thdr->th_sport)!=pingport) break;
					gettimeofday(&tv1, NULL);
					if(!(i=TIMEVAL_MSEC_DIFF(tv1, tv2))) i++;
					if(verbose>1) fprintf(stdout, "Time to get a RST back: %d ms\n", i);
					timeout+=i;
					nb_responses++;
					nbretries=0;
					send=1;
					break;
			}
		}
		else // handle timeout
		{
			gettimeofday(&tv1, NULL);
			if(TIMEVAL_MSEC_DIFF(tv1, tv2)>PING_TIMEOUT)
			{
				nbretries++;
				send=1;
			}
		}
	} while(nb_responses<3 && nbretries<3);

	if(nbretries<3)
	{
		timeout=(timeout*TIMEOUT_FACTOR)/nb_responses;
		if(verbose) fprintf(stdout, "Timeout value: %d ms\n", timeout);
	}
	else
	{
		timeout=-1;
		fprintf(stderr, "Too much timeouts during the timeout evaluation\n");
	}

	free(my_packet);
	pcap_close(pdescr);
	libnet_close_link_interface(interface);

	return(timeout);
}

int ip_eval_timeout(char *dev, int rseed, int verbose, u_int32_t srcip, u_int32_t dstip, u_int16_t pingport, u_char *src_mac)
{
	struct pcap *pdescr;
	struct pcap_pkthdr phdr;
	struct libnet_link_int *interface;
	struct libnet_ethernet_hdr *ehdr;
	struct libnet_arp_hdr *ahdr, duplic;
	struct libnet_ip_hdr *ihdr;
	struct libnet_tcp_hdr *thdr;
	char ebuf[GPS_ERRBUF_SIZE];
	const u_char *packet;
	u_char *my_packet;
	int raw_sock, timeout=0, i, send=1, nb_responses=0, nbretries=0;
	struct timeval tv1, tv2;

	if(!(interface=libnet_open_link_interface(dev, ebuf)))
		libnet_error(LIBNET_ERR_FATAL, "libnet_open_link_int failed (%s)\n", ebuf);
	if((raw_sock=libnet_open_raw_sock(IPPROTO_RAW))==-1)
		libnet_error(LIBNET_ERR_FATAL, "libnet_open_raw_sock failed\n");
	if(!(pdescr=pcap_open_live(dev, 65536, 1, -1, ebuf)))
		libnet_error(LIBNET_ERR_FATAL, "pcap_open_live failed (%s)\n", ebuf);
	unblock_socket(pdescr->fd);

	if(!(my_packet=(u_char *)malloc(GPS_PACKET))) error(NULL, -2);

	do
	{
		if(send)
		{
			libnet_build_tcp(libnet_get_prand(rseed)+1024, pingport, 65535*libnet_get_prand(rseed)*libnet_get_prand(rseed), 65535*libnet_get_prand(rseed)*libnet_get_prand(rseed), TH_ACK, 1024, 0, NULL, 0, my_packet+GPS_IP_H);
			libnet_build_ip(GPS_TCP_H, IPTOS_LOWDELAY, libnet_get_prand(rseed)*libnet_get_prand(rseed), 0, 255, IPPROTO_TCP, srcip, dstip, NULL, 0, my_packet);
			if(libnet_do_checksum(my_packet, IPPROTO_TCP, GPS_TCP_H)==-1)
				libnet_error(LIBNET_ERR_FATAL, "libnet_do_checksum failed\n");
			i=0; while(libnet_write_ip(raw_sock, my_packet, GPS_PACKET)==-1 && i++<3);
			if(i<3)
			{
				send=0;
				gettimeofday(&tv2, NULL);
			}
			else
			{
				libnet_error(LIBNET_ERR_WARNING, "libnet_write_ip failed\n");
				continue;
			}
		}
		if((packet=(u_char *)pcap_next(pdescr, &phdr)))
		{
			ehdr=(struct libnet_ethernet_hdr *)packet;
			switch(ntohs(ehdr->ether_type))
			{
				case ETHERTYPE_ARP:
					ahdr=(struct libnet_arp_hdr *)((u_char *)ehdr+ETHER_HDR_LEN);
					if(ntohs(ahdr->ar_op)!=ARPOP_REQUEST) break;
					if(*(u_int32_t *)ahdr->ar_tpa!=srcip) break;
					duplic=*ahdr;
					ahdr->ar_op=ntohs(ARPOP_REPLY);
					for(i=0; i<GPS_ETH_ALEN; i++)
					{
						ahdr->ar_sha[i]=ehdr->ether_shost[i]=src_mac[i];
						ahdr->ar_tha[i]=ehdr->ether_dhost[i]=duplic.ar_sha[i];
					}
					for(i=0; i<4; i++)
					{
						ahdr->ar_spa[i]=duplic.ar_tpa[i];
						ahdr->ar_tpa[i]=duplic.ar_spa[i];
					}
					if(libnet_write_link_layer(interface, dev, (u_char *)packet, ETHER_HDR_LEN+sizeof(struct libnet_arp_hdr))==-1)
						libnet_error(LIBNET_ERR_WARNING, "libnet_write_link_layer failed\n");
					break;
				case ETHERTYPE_IP:
					ihdr=(struct libnet_ip_hdr *)((u_char *)ehdr+ETHER_HDR_LEN);
					if(ihdr->ip_src.s_addr!=dstip || ihdr->ip_dst.s_addr!=srcip || ihdr->ip_p!=IPPROTO_TCP || (ihdr->ip_off & ~ntohs(IP_DF))) break;
					thdr=(struct libnet_tcp_hdr *)((u_char *)ihdr+4*ihdr->ip_hl);
					if(!(thdr->th_flags & TH_RST) || ntohs(thdr->th_sport)!=pingport) break;
					gettimeofday(&tv1, NULL);
					if(!(i=TIMEVAL_MSEC_DIFF(tv1, tv2))) i++;
					if(verbose>1) fprintf(stdout, "Time to get a RST back: %d ms\n", i);
					timeout+=i;
					nb_responses++;
					nbretries=0;
					send=1;
					break;
			}
		}
		else // handle timeout
		{
			gettimeofday(&tv1, NULL);
			if(TIMEVAL_MSEC_DIFF(tv1, tv2)>PING_TIMEOUT)
			{
				nbretries++;
				send=1;
			}
		}
	} while(nb_responses<3 && nbretries<3);

	if(nbretries<3)
	{
		timeout=(timeout*TIMEOUT_FACTOR)/nb_responses;
		if(verbose) fprintf(stdout, "Timeout value: %d ms\n", timeout);
	}
	else
	{
		timeout=-1;
		fprintf(stderr, "Too much timeouts during the timeout evaluation\n");
	}

	free(my_packet);
	pcap_close(pdescr);
	libnet_close_raw_sock(raw_sock);
	libnet_close_link_interface(interface);

	return(timeout);
}


