#ifndef ROUTE_H
#define ROUTE_H

#include<sys/types.h>
#include<sys/socket.h>
#include<net/if.h>


#define DELIM " \t\n"
#define FROUTE "/proc/net/route"

typedef struct {
	char name[IFNAMSIZ];
	u_int32_t ip;
	u_int32_t netmask;
} netdev;

typedef struct {
	int nb;
	netdev *dev_list;
} devlist;

typedef struct {
	char ifname[IFNAMSIZ];
	u_int32_t gateway;
} route_elt;


// functions
devlist *get_localdevs();
void free_devlist(devlist *dl);
int islocalhost(devlist *dl, u_int32_t ip);
netdev *get_suitable_dev(devlist *dl, u_int32_t target_ip);
u_int32_t get_gateway_ip(u_int32_t dstip);
route_elt *get_route(u_int32_t dstip, devlist *devicelist);

#endif
