#include<errno.h>
#include<libnet.h>
#ifndef PCAP_SUBDIR
#include<pcap.h>
#else
#include<pcap/pcap.h>
#endif
#include "pcap-int.h"

#include "timeout.h"

// timeout evaluation using link layer
int ethernet_eval_timeout(char *dev, int verbose, u_int32_t srcip, u_int32_t dstip, u_int16_t pingport, u_char *src_mac, u_char *dst_mac)
{
	char ebuf[GPS_ERRBUF_SIZE];
	struct pcap_pkthdr phdr;
	struct libnet_arp_hdr duplic;
	struct timeval tv1, tv2;
	struct pcap                *pdescr;
	struct libnet_link_int     *interface;
	struct libnet_ethernet_hdr *ehdr;
	struct libnet_arp_hdr      *ahdr;
	struct libnet_ip_hdr       *ihdr;
	struct libnet_tcp_hdr      *thdr;
	const u_char               *packet;
	u_char                     *my_packet;
	int timeout=0, i, send=1, nb_responses=0, nbretries=0;

	if(!(interface=libnet_open_link_interface(dev, ebuf)))
		libnet_error(LIBNET_ERR_FATAL, "ethernet_eval_timeout: libnet_open_link_int failed (%s)\n", ebuf);
	if(!(pdescr=pcap_open_live(dev, 256, 1, 0, ebuf)))
		libnet_error(LIBNET_ERR_FATAL, "ethernet_eval_timeout: pcap_open_live failed (%s)\n", ebuf);
	unblock_socket(pdescr->fd);

	if(!(my_packet=(u_char *)malloc(GPS_TCP_TRAME))) { perror("ethernet_eval_timeout: malloc"); exit(-1); }

	do {
		if(send) {
			libnet_build_tcp(gps_get_prand()%65000|1024, pingport, gps_get_prand(), gps_get_prand(), TH_ACK, 1024, 0, NULL, 0, my_packet+GPS_ETH_H+GPS_IP_H);
			libnet_build_ip(GPS_TCP_H, IPTOS_LOWDELAY, gps_get_prand(), 0, 255, IPPROTO_TCP, srcip, dstip, NULL, 0, my_packet+GPS_ETH_H);
			libnet_build_ethernet(dst_mac, src_mac, ETHERTYPE_IP, NULL, 0, my_packet);
			if(libnet_do_checksum(my_packet+GPS_ETH_H, IPPROTO_TCP, GPS_TCP_H)==-1 || libnet_do_checksum(my_packet+GPS_ETH_H, IPPROTO_IP, GPS_IP_H)==-1)
				libnet_error(LIBNET_ERR_FATAL, "ethernet_eval_timeout: libnet_do_checksum failed\n");
			i=0; while(libnet_write_link_layer(interface, dev, my_packet, GPS_TCP_TRAME)==-1 && i++<3);
			if(i<3) {
				send=0;
				gettimeofday(&tv2, NULL);
			} else {
				libnet_error(LIBNET_ERR_WARNING, "ethernet_eval_timeout: libnet_write_link_layer failed\n");
				continue;
			}
		}
		if((packet=(u_char *)pcap_next(pdescr, &phdr))) {
			ehdr=(struct libnet_ethernet_hdr *)packet;
			switch(ntohs(ehdr->ether_type)) {
				case ETHERTYPE_ARP:
					ahdr=(struct libnet_arp_hdr *)((u_char *)ehdr+GPS_ETH_H);
					if(ntohs(ahdr->ar_op)!=ARPOP_REQUEST) break;
					if(*(u_int32_t *)ahdr->ar_tpa!=srcip) break;
					duplic=*ahdr;
					ahdr->ar_op=ntohs(ARPOP_REPLY);
					for(i=0; i<GPS_ETH_ALEN; i++) {
						ahdr->ar_sha[i]=ehdr->ether_shost[i]=src_mac[i];
						ahdr->ar_tha[i]=ehdr->ether_dhost[i]=duplic.ar_sha[i];
					}
					for(i=0; i<4; i++) {
						ahdr->ar_spa[i]=duplic.ar_tpa[i];
						ahdr->ar_tpa[i]=duplic.ar_spa[i];
					}
					if(libnet_write_link_layer(interface, dev, (u_char *)packet, GPS_ETH_H+sizeof(struct libnet_arp_hdr))==-1)
						libnet_error(LIBNET_ERR_WARNING, "libnet_write_link_layer failed\n");
					break;
				case ETHERTYPE_IP:
					ihdr=(struct libnet_ip_hdr *)((u_char *)ehdr+GPS_ETH_H);
					if(ihdr->ip_src.s_addr!=dstip || ihdr->ip_dst.s_addr!=srcip || ihdr->ip_p!=IPPROTO_TCP || (ihdr->ip_off & ~ntohs(IP_DF))) break;
					thdr=(struct libnet_tcp_hdr *)((u_char *)ihdr+(ihdr->ip_hl<<2));
					if(!(thdr->th_flags & TH_RST) || ntohs(thdr->th_sport)!=pingport) break;
					gettimeofday(&tv1, NULL);
					if(!(i=TIMEVAL_MSEC_DIFF(tv1, tv2))) i++;
					if(verbose>1) fprintf(stdout, "Time to get a RST back: %d ms\n", i);
					timeout+=i;
					nb_responses++;
					nbretries=0;
					send=1;
					break;
			}
		} else { // handle timeout
			gettimeofday(&tv1, NULL);
			if(TIMEVAL_MSEC_DIFF(tv1, tv2)>PING_TIMEOUT) {
				nbretries++;
				send=1;
			}
		}
	} while(nb_responses<NB_PING && nbretries<3);

	if(nbretries<3) {
		timeout=(timeout*TIMEOUT_FACTOR)/nb_responses;
		if(verbose) fprintf(stdout, "Timeout value: %d ms\n", timeout);
	} else {
		timeout=-1;
		fprintf(stderr, "Too much timeouts during the timeout evaluation\n");
	}

	free(my_packet);
	pcap_close(pdescr);
	libnet_close_link_interface(interface);

	return(timeout);
}


// timeout evaluation using IP layer
int ip_eval_timeout(char *dev, int verbose, u_int32_t srcip, u_int32_t dstip, u_int16_t pingport, u_char *src_mac)
{
	char ebuf[GPS_ERRBUF_SIZE];
	struct pcap_pkthdr phdr;
	struct libnet_arp_hdr duplic;
	struct timeval tv1, tv2;
	struct pcap                *pdescr;
	struct libnet_link_int     *interface;
	struct libnet_ethernet_hdr *ehdr;
	struct libnet_arp_hdr      *ahdr;
	struct libnet_ip_hdr       *ihdr;
	struct libnet_tcp_hdr      *thdr;
	const u_char               *packet;
	u_char                     *my_packet;
	int raw_sock, timeout=0, i, send=1, nb_responses=0, nbretries=0;

	if(!(interface=libnet_open_link_interface(dev, ebuf)))
		libnet_error(LIBNET_ERR_FATAL, "ip_eval_timeout: libnet_open_link_int failed (%s)\n", ebuf);
	if((raw_sock=libnet_open_raw_sock(IPPROTO_RAW))==-1)
		libnet_error(LIBNET_ERR_FATAL, "ip_eval_timeout: libnet_open_raw_sock failed\n");
	if(!(pdescr=pcap_open_live(dev, 65536, 1, -1, ebuf)))
		libnet_error(LIBNET_ERR_FATAL, "ip_eval_timeout: pcap_open_live failed (%s)\n", ebuf);
	unblock_socket(pdescr->fd);

	if(!(my_packet=(u_char *)malloc(GPS_TCP_PACKET))) { perror("ip_eval_timeout: malloc"); exit(-1); }

	do {
		if(send) {
			libnet_build_tcp(gps_get_prand()%65000|1024, pingport, gps_get_prand(), gps_get_prand(), TH_ACK, 1024, 0, NULL, 0, my_packet+GPS_IP_H);
			libnet_build_ip(GPS_TCP_H, IPTOS_LOWDELAY, gps_get_prand(), 0, 255, IPPROTO_TCP, srcip, dstip, NULL, 0, my_packet);
			if(libnet_do_checksum(my_packet, IPPROTO_TCP, GPS_TCP_H)==-1)
				libnet_error(LIBNET_ERR_FATAL, "ip_eval_timeout: libnet_do_checksum failed\n");
			i=0; while(libnet_write_ip(raw_sock, my_packet, GPS_TCP_PACKET)==-1 && i++<3);
			if(i<3) {
				send=0;
				gettimeofday(&tv2, NULL);
			} else {
				libnet_error(LIBNET_ERR_WARNING, "ip_eval_timeout: libnet_write_ip failed\n");
				continue;
			}
		}
		if((packet=(u_char *)pcap_next(pdescr, &phdr))) {
			ehdr=(struct libnet_ethernet_hdr *)packet;
			switch(ntohs(ehdr->ether_type)) {
				case ETHERTYPE_ARP:
					ahdr=(struct libnet_arp_hdr *)((u_char *)ehdr+GPS_ETH_H);
					if(ntohs(ahdr->ar_op)!=ARPOP_REQUEST) break;
					if(*(u_int32_t *)ahdr->ar_tpa!=srcip) break;
					duplic=*ahdr;
					ahdr->ar_op=ntohs(ARPOP_REPLY);
					for(i=0; i<GPS_ETH_ALEN; i++) {
						ahdr->ar_sha[i]=ehdr->ether_shost[i]=src_mac[i];
						ahdr->ar_tha[i]=ehdr->ether_dhost[i]=duplic.ar_sha[i];
					}
					for(i=0; i<4; i++) {
						ahdr->ar_spa[i]=duplic.ar_tpa[i];
						ahdr->ar_tpa[i]=duplic.ar_spa[i];
					}
					if(libnet_write_link_layer(interface, dev, (u_char *)packet, GPS_ETH_H+sizeof(struct libnet_arp_hdr))==-1)
						libnet_error(LIBNET_ERR_WARNING, "ip_eval_timeout: libnet_write_link_layer failed\n");
					break;
				case ETHERTYPE_IP:
					ihdr=(struct libnet_ip_hdr *)((u_char *)ehdr+GPS_ETH_H);
					if(ihdr->ip_src.s_addr!=dstip || ihdr->ip_dst.s_addr!=srcip || ihdr->ip_p!=IPPROTO_TCP || (ihdr->ip_off & ~ntohs(IP_DF))) break;
					thdr=(struct libnet_tcp_hdr *)((u_char *)ihdr+(ihdr->ip_hl<<2));
					if(!(thdr->th_flags & TH_RST) || ntohs(thdr->th_sport)!=pingport) break;
					gettimeofday(&tv1, NULL);
					if(!(i=TIMEVAL_MSEC_DIFF(tv1, tv2))) i++;
					if(verbose>1) fprintf(stdout, "Time to get a RST back: %d ms\n", i);
					timeout+=i;
					nb_responses++;
					nbretries=0;
					send=1;
					break;
			}
		} else { // handle timeout
			gettimeofday(&tv1, NULL);
			if(TIMEVAL_MSEC_DIFF(tv1, tv2)>PING_TIMEOUT) {
				nbretries++;
				send=1;
			}
		}
	} while(nb_responses<NB_PING && nbretries<3);

	if(nbretries<3) {
		timeout=(timeout*TIMEOUT_FACTOR)/nb_responses;
		if(verbose) fprintf(stdout, "Timeout value: %d ms\n", timeout);
	} else {
		timeout=-1;
		fprintf(stderr, "Too much timeouts during the timeout evaluation\n");
	}

	free(my_packet);
	pcap_close(pdescr);
	libnet_close_raw_sock(raw_sock);
	libnet_close_link_interface(interface);

	return(timeout);
}


