#include<stdlib.h>
#include<errno.h>
#include "fwrd.h"

void init_fwrd_elt(struct fwrd_elt *elt, u_int32_t ip)
{
	elt->ip=ip;
	elt->port_list=NULL;
	elt->nb_ports=0;
}

void add_fwrd_port(struct fwrd_elt *elt, u_int16_t port)
{
	if((elt->port_list=(u_int16_t *)realloc(elt->port_list, (elt->nb_ports+1)*sizeof(u_int16_t))))
		elt->port_list[(elt->nb_ports)++]=port;
	else { perror("add_fwrd_port: realloc"); exit(-1); }
}

void free_fwrd_port_list(struct fwrd_elt *elt)
{
	free(elt->port_list);
	elt->port_list=NULL;
	elt->nb_ports=0;
}

void fwrd_print_port_list(struct fwrd_elt *elt, char *format)
{
	int i;
	for(i=0; i<elt->nb_ports; i++)
		fprintf(stdout, format, elt->port_list[i]);
}

void fwrd_print_reverse_port_list(struct fwrd_elt *elt, char *format, struct gotcha_port *tab_port, int nbports)
{
	int i, j;
	for(i=0, j=0; j<elt->nb_ports && i<nbports; i++)
		if(tab_port[i].port<elt->port_list[j])
			fprintf(stdout, format, tab_port[i].port);
		else j++;
	while(i<nbports) fprintf(stdout, format, tab_port[i++].port);
}

int fwrd_compare(u_int16_t *port1, u_int16_t *port2)
{
	return(*port1-*port2);
}

