#ifndef GPS_H
#define GPS_H

#include<libnet.h>
#ifndef PCAP_SUBDIR
#include<pcap.h>
#else
#include<pcap/pcap.h>
#endif
#include<sys/types.h>
#include<time.h>
#include"rand.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef VERSION
#define GPS_VERSION VERSION
#else
#define GPS_VERSION "0.9.2b"
#endif


// NULL flag
#define TH_NULL 0

// spoofing options
#define MAC_SPOOF 1
#define IP_SPOOF  0

// scan types
#define SYN_SCAN  TH_SYN
#define FIN_SCAN  TH_FIN
#define ACK_SCAN  TH_ACK
#define XMAS_SCAN TH_FIN|TH_URG|TH_PUSH
#define NULL_SCAN TH_NULL
#define RAND_SCAN -1
#define FWRD_SCAN -2
#define UDP_SCAN  -3

// frag options
#define NO_FRAG		0
#define TINY_FRAG	1
#define OVERLAP_FRAG	2

// redefines
#define GPS_ERRBUF_SIZE	(LIBNET_ERRBUF_SIZE<PCAP_ERRBUF_SIZE ? PCAP_ERRBUF_SIZE : LIBNET_ERRBUF_SIZE)
#define GPS_ETH_H	(LIBNET_ETH_H)
#define GPS_IP_H	(LIBNET_IP_H)
#define GPS_TCP_H	(LIBNET_TCP_H)
#define GPS_UDP_H	(LIBNET_UDP_H)
#define GPS_TCP_PACKET	(GPS_IP_H+GPS_TCP_H)
#define GPS_UDP_PACKET	(GPS_IP_H+GPS_UDP_H)
#define GPS_TCP_TRAME	(GPS_ETH_H+GPS_IP_H+GPS_TCP_H)
#define GPS_UDP_TRAME	(GPS_ETH_H+GPS_IP_H+GPS_UDP_H)
#define GPS_ETH_ALEN	(ETHER_ADDR_LEN)

// other
#define MAX_RETRIES	16
#define MAX_RETRIES_FW	8
#define MAX_WINDOW	256
#define MIN_WINDOW	8
#define MIN_WINDOW_FW	24
#ifdef HAVE_LINUX
#define BASIC_WINDOW	256
#else
#define BASIC_WINDOW	32 // network seems really faster under BSD
#endif
#define TIMEVAL_MSEC_DIFF(a, b) ((((a).tv_sec-(b).tv_sec)*1000)+(((a).tv_usec-(b).tv_usec)/1000))

// codes used by the sniffer and the packet
// injector to communicate through the socket pair
#define GPS_1ST_BLAST_OVER	-1
#define GPS_SCAN_OVER		-2
#define GPS_NEXT_IP		-3

struct arp_elt {
	u_char ea[GPS_ETH_ALEN];	// ethernet address
	u_int32_t ip;			// IP address
};

struct port_list_elt {
	struct port_list_elt *prec;		// pointer to the precedent port_list_elt
	struct port_list_elt *next;		// pointer to the next port_list_elt
	int offset;				// (indexed) offset of the matching port_elt
};

struct port_elt {
	struct timeval tv;	// sending date
	u_int32_t ip;		// src_ip GPS uses
	int seq;		// seq nb
	int ack;		// ack nb
	int nbretries;		// nb of retries
	u_int16_t dst_port;	// dst_port
	u_int16_t src_port;	// src_port
	u_int16_t ip_id;	// IP ID
};

struct gotcha_port {
	u_int16_t port;		// port number
	u_int16_t gotcha;	// port state (open/closed/filtered)
#define GPS_PORT_OPEN		1
#define GPS_PORT_CLOSED		2
#define GPS_PORT_UNFILTERED	GPS_PORT_CLOSED
};

// functions:
inline void get_ea(char *ea);
struct port_list_elt *add_port_to_list  (struct port_list_elt *pl, int offset, int *nb_packets_being_handled);
struct port_list_elt *del_port_from_list(struct port_list_elt *pl, int offset, int *nb_packets_being_handled);
inline void init_port(int i, u_int16_t port);
int  search_port(struct gotcha_port *tab, u_int16_t port);
void reverse_scan_disp();
int  search_src_ip(u_int32_t ip);
int  compare_arp_elt(struct arp_elt *addr1, struct arp_elt *addr2);
void unblock_socket(int fd);
void block_socket(int fd);
void randomize_port_order(u_int16_t *tab_switch_o2r, u_int16_t *tab_switch_r2o);
void ip_timeout_handling(int sd, int raw_sock, int *nb_packets_being_handled, struct port_list_elt **packets_being_handled_list, u_int16_t *tab_switch_o2r, char *packets, char *frag_packets, int packet_length);
void ip_packet_generator();
void ethernet_timeout_handling(int sd, struct libnet_link_int *interface, int *nb_packets_being_handled, struct port_list_elt **packets_being_handled_list, u_int16_t *tab_switch_o2r, char *packets, char *frag_packets, int packet_length);
void ethernet_packet_generator();
void usage(char *cmd);


#endif
