#ifndef MAC_ARP_H
#define MAC_ARP_H

#include "gps.h"

#define ARP_TIMEOUT 1000

typedef struct
{
	struct sockaddr_in arp_pa;
	struct sockaddr    arp_ha;
	int arp_flags;
	struct sockaddr_in arp_netmask;
	char arp_dev[16];
} my_arpreq;

// functions
int send_ARP_request(char *dev, u_int32_t *srcip, u_int32_t *dstip, u_char *src_mac, u_char *dst_mac);
int get_mac(u_int32_t ip, char *mac, char *dev);

#define IS_ON_LOCAL_NET(ip, netmask, network) ((ip & netmask)==network)

#endif
