#include "route.h"

#include<sys/ioctl.h>
#include<sys/socket.h>
#include<libnet.h>
#include<stdio.h>
#include<errno.h>
#include<stdlib.h>
#include<string.h>

/*
 * some parts are taken from nmap
 */
devlist *get_localdevs()
{
	char buffer[10240]; /* weird size ? -- taken from nmap */
	struct ifconf ifc;
	static devlist localdevs;
	struct ifreq ifr_nm, *ifr;
	int sd, i, len;

	localdevs.nb=0;
	localdevs.dev_list=NULL;

	if((sd=socket(AF_INET, SOCK_DGRAM, 0))<0) 
		{ perror("get_localdevs: socket"); return(NULL); }

	ifc.ifc_len=sizeof(buffer);
	ifc.ifc_ifcu.ifcu_buf=buffer;
	// get devices and their addresses
	if(ioctl(sd, SIOCGIFCONF, &ifc)<0)
		{ perror("get_localdevs: ioctl"); close(sd); return(NULL); }

	if(!ifc.ifc_len)
		{ fprintf(stderr, "According to SIOCGIFCONF, you don't have any network interface\n"); close(sd); return(NULL); }

#ifndef HAVE_SOCKADDR_SA_LEN
	len=sizeof(struct ifreq);
#endif

	for(ifr=(struct ifreq *)buffer; ifr && *(char *)ifr && (char *)ifr<buffer+ifc.ifc_len; (*(char **)&ifr)+=len)
	{
#ifdef HAVE_SOCKADDR_SA_LEN
		len=ifr->ifr_addr.sa_len+sizeof(ifr->ifr_name);
#endif
		if(!ifr->ifr_name[0] || ((struct sockaddr_in *)&ifr->ifr_addr)->sin_family!=AF_INET) continue;
		if(!(localdevs.dev_list=(netdev *)realloc(localdevs.dev_list, (localdevs.nb+1)*sizeof(netdev))))
			{ perror("get_localdevs: realloc"); close(sd); return(NULL); }
		memcpy(localdevs.dev_list[localdevs.nb].name, ifr->ifr_name, IFNAMSIZ);
		localdevs.dev_list[localdevs.nb].name[IFNAMSIZ-1]='\0';
		localdevs.dev_list[localdevs.nb].ip=((struct sockaddr_in *)(&ifr->ifr_addr))->sin_addr.s_addr;
		localdevs.nb++;
	}

	// get netmasks
	for(i=0; i<localdevs.nb; i++)
	{
		bzero(&ifr_nm, sizeof(struct ifreq));
		((struct sockaddr_in *)(&ifr_nm.ifr_addr/*netmask*/))->sin_family=AF_INET;
		memcpy(ifr_nm.ifr_name, localdevs.dev_list[i].name, IFNAMSIZ);
		if(ioctl(sd, SIOCGIFNETMASK, (char *)&ifr_nm)<0)
			{ perror("get_localdevs: ioctl"); close(sd); return(NULL); }
		localdevs.dev_list[i].netmask=((struct sockaddr_in *)(&ifr_nm.ifr_addr/*netmask*/))->sin_addr.s_addr;
	}
	close(sd);
	return(&localdevs);
}

void free_devlist(devlist *dl)
{
	free(dl->dev_list);
}

int islocalhost(devlist *dl, u_int32_t ip)
{
	int i;
	for(i=0; i<dl->nb; i++)
		if(ip==dl->dev_list[i].ip)
			return(1);
	return(0);
}

netdev *get_suitable_dev(devlist *dl, u_int32_t target_ip)
{
	int i;
	route_elt *re;

	for(i=0; i<dl->nb; i++)
		if((dl->dev_list[i].ip & dl->dev_list[i].netmask)==(target_ip & dl->dev_list[i].netmask))
			return(&dl->dev_list[i]);
	if((re=get_route(target_ip, dl)))
		for(i=0; i<dl->nb; i++)
			if(!strncmp(dl->dev_list[i].name, re->ifname, IFNAMSIZ-1))
				return(&dl->dev_list[i]);
	return(NULL);
}

u_int32_t get_gateway_ip(u_int32_t dstip)
{
	route_elt *re;
	if(!(re=get_route(dstip, NULL))) return(-1);
	return(re->gateway);
}

// inspired by nmap
route_elt *get_route(u_int32_t dstip, devlist *devicelist)
{
	char buffer[10240];
	static route_elt re;
	struct sockaddr_in sock;
	char *ptr, *endptr;
	unsigned int dst, netmask, i;
	int sd, socklen=sizeof(struct sockaddr_in);
	FILE *rt;

	// search for a /proc/net/route interface
	if((rt=fopen(FROUTE, "rt"))) {
		fgets(buffer, sizeof(buffer), rt);
		while(fgets(buffer, sizeof(buffer), rt)) {
			if(!(ptr=strtok(buffer, DELIM))) continue;	// empty line
			if(*ptr=='*') continue;				// deleted route
			strncpy(re.ifname, ptr, IFNAMSIZ-1); re.ifname[IFNAMSIZ-1]='\0';
			if((ptr=strchr(re.ifname, ':'))) *ptr='\0';	// IP aliasing support
			ptr=strtok(NULL, DELIM);
			endptr=NULL;
			dst=strtoul(ptr, &endptr, 16);
			if(!*ptr || *endptr) continue;			// dst_ip not valid
			ptr=strtok(NULL, DELIM);
			endptr=NULL;
			re.gateway=strtoul(ptr, &endptr, 16);
			if(!*ptr || *endptr) continue;			// gateway not valid
			for(i=0; i<5; i++)
				if(!(ptr=strtok(NULL, DELIM))) break;
			if(!ptr) continue;				// not enough fields
			endptr=NULL;
			netmask=strtoul(ptr, &endptr, 16);
			if(!*ptr || *endptr) continue;			// invalid netmask
			if((dstip & netmask)==dst) {
				fclose(rt);
				return(&re);
			}
		}
		fclose(rt);
	} else {
		if(!devicelist) return(NULL);
		// use connect socket technique (taken from nmap too)
		if((sd=socket(AF_INET, SOCK_DGRAM, 0))==-1)
			{ perror("get_route: socket"); return(NULL); }
		sock.sin_family=AF_INET;
		sock.sin_addr.s_addr=dstip;
		sock.sin_port=ntohs(53);
		if(connect(sd, (struct sockaddr *)&sock, sizeof(struct sockaddr_in))==-1)
			{ perror("get_route: connect"); close(sd); return(NULL); }
		bzero(&sock, sizeof(struct sockaddr_in));
		if(getsockname(sd, (struct sockaddr *)&sock, &socklen)==-1)
			{ perror("get_route: getsockname"); close(sd); return(NULL); }
		// search for a matching network interface
		for(i=0; devicelist->dev_list[i].ip!=sock.sin_addr.s_addr && i<devicelist->nb; i++);
		if(i==devicelist->nb) { fprintf(stderr, "get_route: not able to find a matching device\n"); close(sd); return(NULL); }
		strncpy(re.ifname, devicelist->dev_list[i].name, IFNAMSIZ-1); re.ifname[IFNAMSIZ-1]='\0';
		re.gateway=-1;
		close(sd);
		return(&re);
	}
	return(NULL);
}

