#include<time.h>
#include<errno.h>
#include<stdlib.h>
#include<libnet.h>
#ifndef PCAP_SUBDIR
#include<pcap.h>
#else
#include<pcap/pcap.h>
#endif
#include "pcap-int.h"
#include "src-ip.h"

// this function TCP pings every machine on the local network
// and return the list of the host that seem down
struct arp_elt *get_src_ip_list(netdev *nd, u_int16_t pingport, int *nbip, u_int32_t dstip)
{
	char ebuf[GPS_ERRBUF_SIZE];
	u_char my_packet[GPS_TCP_PACKET];
	struct pcap_pkthdr phdr;
	struct timeval tv1, tv2;
	int raw_sock, host_up;
	u_int32_t ip, ip_max;
	struct pcap           *pdescr;
	struct arp_elt        *srcip=NULL;
	struct libnet_ip_hdr  *ihdr;
	struct libnet_tcp_hdr *thdr;
	const u_char          *packet;

	*nbip=0;
	if(!(pdescr=pcap_open_live(nd->name, 256, 1, 0, ebuf)))
		libnet_error(LIBNET_ERR_FATAL, "get_src_ip_list: pcap_open_live failed (%s)\n", ebuf);
	if((raw_sock=libnet_open_raw_sock(IPPROTO_RAW))==-1)
		libnet_error(LIBNET_ERR_FATAL, "get_src_ip_list: libnet_open_raw_sock: not able to open a raw socket\n");
	unblock_socket(pdescr->fd);


	for(ip=nd->ip & nd->netmask, ip_max=ip | ~nd->netmask; ntohl(ip)<ntohl(ip_max); ip+=ntohl(1))
	{
		if(!(ip & ~nd->netmask) || (ip & ~nd->netmask)==~nd->netmask || ip==nd->ip || ip==dstip) continue;
		libnet_build_tcp(gps_get_prand()%65000+1024, pingport, gps_get_prand(), gps_get_prand(), TH_ACK, 1024, 0, NULL, 0, my_packet+GPS_IP_H);
		libnet_build_ip(GPS_TCP_H, IPTOS_LOWDELAY, gps_get_prand(), 0, 255, IPPROTO_TCP, nd->ip, ip, NULL, 0, my_packet);
		if(libnet_do_checksum(my_packet, IPPROTO_TCP, GPS_TCP_H)==-1)
			{ libnet_error(LIBNET_ERR_WARNING, "get_src_ip_list: libnet_do_checksum: TCP checksum failed\n"); continue; }
		if(libnet_write_ip(raw_sock, my_packet, GPS_TCP_PACKET)<GPS_TCP_PACKET)
			{ libnet_error(LIBNET_ERR_WARNING, "get_src_ip_list: libnet_write_ip: not able to write to the raw socket\n"); continue; }
		gettimeofday(&tv1, NULL);
		host_up=0;
		while(!host_up) {
			if((packet=pcap_next(pdescr, &phdr))) {
				if(ntohs(((struct libnet_ethernet_hdr *)packet)->ether_type)==ETHERTYPE_IP) {
					ihdr=(struct libnet_ip_hdr *)(packet+GPS_ETH_H);
					if(ihdr->ip_src.s_addr==ip && ihdr->ip_dst.s_addr==nd->ip && !(ihdr->ip_off & ~ntohs(IP_DF)) && ihdr->ip_p==IPPROTO_TCP) {
						thdr=(struct libnet_tcp_hdr *)((u_char *)ihdr+(ihdr->ip_hl<<2));
						if((thdr->th_flags & TH_RST) && ntohs(thdr->th_sport==pingport))
							host_up=1;
					}
				}
			}
			if(!host_up) {
				gettimeofday(&tv2, NULL);
				if(TIMEVAL_MSEC_DIFF(tv2, tv1)>LAN_PING_TIMEOUT) {
					/* this host didn't answer, lets assume it is down */
					if(!(srcip=(struct arp_elt *)realloc(srcip, (*nbip+1)*sizeof(struct arp_elt)))) { perror("get_src_ip_list: realloc"); exit(-1); }
					srcip[*nbip].ip=ntohl(ip); // ntohl translates the IPs to host byte order
					get_ea(srcip[*nbip].ea);
					(*nbip)++;
					host_up=1;
				}
			}
		}
	}

	if(libnet_close_raw_sock(raw_sock)==-1)
		libnet_error(LIBNET_ERR_WARNING, "get_src_ip_list: libnet_close_raw_sock failed\n");
	pcap_close(pdescr);
	return(srcip);
}

