#ifndef TIMEOUT_H
#define TIMEOUT_H

#include "gps.h"

// timeout definitions:

// on the same LAN
#define MAX_TIMEOUT_LOCAL	2000
#define DEFAULT_TIMEOUT_LOCAL	200

// on an other network
#define MAX_TIMEOUT_DIST	10000
#define DEFAULT_TIMEOUT_DIST	2000

// localhost
#define MAX_TIMEOUT_LOOPB	64
#define DEFAULT_TIMEOUT_LOOPB	5

// other
#define PING_TIMEOUT		5000
#define TIMEOUT_FACTOR		4
#define NB_PING			16

int ethernet_eval_timeout(char *dev, int verbose, u_int32_t srcip, u_int32_t dstip, u_int16_t pingport, u_char *src_mac, u_char *dst_mac);

int       ip_eval_timeout(char *dev, int verbose, u_int32_t srcip, u_int32_t dstip, u_int16_t pingport, u_char *src_mac);

#endif

