#include "mac-arp.h"

#include<time.h>
#include<sys/socket.h>
#include<errno.h>
#include<libnet.h>
#ifndef PCAP_SUBDIR
#include<pcap.h>
#else
#include<pcap/pcap.h>
#endif
#include "pcap-int.h"


int send_ARP_request(char *dev, u_int32_t *srcip, u_int32_t *dstip, u_char *src_mac, u_char *dst_mac)
{
	char ebuf[GPS_ERRBUF_SIZE];
	struct pcap_pkthdr phdr;
	struct timeval tv, current;
	u_char null_mac[GPS_ETH_ALEN], broadcast_mac[GPS_ETH_ALEN];
	struct pcap *pdescr;
	struct libnet_link_int *interface;
	struct libnet_ethernet_hdr *ehdr;
	struct libnet_arp_hdr *ahdr;
	const u_char *sniffed_packet;
	u_char *packet;
	int nbretries=0, i;

	for(i=0; i<GPS_ETH_ALEN; i++) {
		null_mac[i]=0;
		broadcast_mac[i]=255;
	}

	libnet_init_packet(LIBNET_ETH_H+LIBNET_ARP_H, &packet);
	if(!packet) libnet_error(LIBNET_ERR_FATAL, "send_ARP_request: libnet_init_packet failed\n");

	if(!(interface=libnet_open_link_interface(dev, ebuf)))
		libnet_error(LIBNET_ERR_FATAL, "send_ARP_request: libnet_open_link_interface failed (%s)\n", ebuf);
	if(!(pdescr=pcap_open_live(dev, 256, 1, 0, ebuf)))
		libnet_error(LIBNET_ERR_FATAL, "send_ARP_request: pcap_open_live: %s\n", ebuf);
	unblock_socket(pdescr->fd);

#ifdef ARPHRD_ETHER // I think it should be ARPHDR_ETHER
	if(libnet_build_arp(ARPHRD_ETHER, ETHERTYPE_IP, GPS_ETH_ALEN, 4, ARPOP_REQUEST, src_mac, (u_char *)srcip, null_mac, (u_char *)dstip, NULL, 0, packet+LIBNET_ETH_H)==-1)
		libnet_error(LIBNET_ERR_FATAL, "send_ARP_request: libnet_build_arp failed\n");
#else
	if(libnet_build_arp(ARPHDR_ETHER, ETHERTYPE_ARP, GPS_ETH_ALEN, 4, ARPOP_REQUEST, src_mac, (u_char *)srcip, null_mac, (u_char *)dstip, NULL, 0, packet+LIBNET_ETH_H)==-1)
		libnet_error(LIBNET_ERR_FATAL, "send_ARP_request: libnet_build_arp failed\n");
#endif
	if(libnet_build_ethernet(broadcast_mac, src_mac, ETHERTYPE_ARP, NULL, 0, packet)==-1)
		libnet_error(LIBNET_ERR_FATAL, "send_ARP_request: libnet_build_ethernet failed\n");

	i=0; while(libnet_write_link_layer(interface, dev, packet, LIBNET_ETH_H+LIBNET_ARP_H)==-1 && i++<3);
	if(nbretries>2) libnet_error(LIBNET_ERR_FATAL, "send_ARP_request: libnet_write_link_layer failed\n");
	gettimeofday(&tv, NULL);

	do
	{
		if((sniffed_packet=pcap_next(pdescr, &phdr)))
		{
			ehdr=(struct libnet_ethernet_hdr *)sniffed_packet;
			if(ntohs(ehdr->ether_type)==ETHERTYPE_ARP)
			{
				ahdr=(struct libnet_arp_hdr *)((u_char *)ehdr+GPS_ETH_H);
				if(ntohs(ahdr->ar_op)==ARPOP_REPLY && *(u_int32_t *)ahdr->ar_spa==*dstip)
				{
					for(i=0; i<GPS_ETH_ALEN; i++) dst_mac[i]=ahdr->ar_sha[i];
					pcap_close(pdescr);
					if(libnet_close_link_interface(interface)==-1)
						libnet_error(LIBNET_ERR_WARNING, "send_ARP_request: libnet_close_link_interface faild\n");
					libnet_destroy_packet(&packet);
					return(0);
				}
			}
		}
		gettimeofday(&current, NULL);
		if(TIMEVAL_MSEC_DIFF(current, tv)>ARP_TIMEOUT)
		{
			i=0; while(libnet_write_link_layer(interface, dev, packet, LIBNET_ETH_H+LIBNET_ARP_H)==-1 && i++<3);
			tv=current;
			nbretries++;
		}		
	} while(nbretries<5);

	pcap_close(pdescr);
	if(libnet_close_link_interface(interface)==-1)
		libnet_error(LIBNET_ERR_WARNING, "send_ARP_request: libnet_close_link_interface failed\n");
	libnet_destroy_packet(&packet);
	return(-1);
}

int get_mac(u_int32_t ip, char *mac, char *dev)
{
#ifndef HAVE_BSD
	my_arpreq arpr;
	int sd;

	if((sd=socket(AF_INET, SOCK_DGRAM, 0))<0)
		{ perror("get_mac: socket"); return(-1); }
	arpr.arp_pa.sin_family=AF_INET;
	arpr.arp_pa.sin_addr.s_addr=ip;
	arpr.arp_flags=0;
	strncpy(arpr.arp_dev, dev, 15);
	arpr.arp_dev[15]='\0';
	if(ioctl(sd, SIOCGARP, &arpr)==-1)
		{ /*perror("get_mac: ioctl");*/ close(sd); return(-1); }
	close(sd);
	memcpy(mac, arpr.arp_ha.sa_data, GPS_ETH_ALEN);
	return(0);
#else
	return(-1);
#endif
}

