/* The aht hello world:
 *
 * We adds two keys using the function ht_add(),
 * later, we search for this two keys, printing the value associated. */

#include <stdio.h>
#include <stdlib.h>

#include <aht.h>

int main(void)
{
	struct hashtable t;
	unsigned int index;

	ht_init(&t);

	ht_add(&t, "hello", 5, "The word -hello-", 17); /* 16 + nul term */
	ht_add(&t, "world", 5, "The word -world-", 17);

	ht_search(&t, "hello", 5, NULL, &index);
	printf("key hello, value: %s\n", (char*) t.table[index]->data);
	ht_search(&t, "world", 5, NULL, &index);
	printf("key world, value: %s\n", (char*) t.table[index]->data);

	/* How to run an hash table */
	for (index = 0; ;) {
		int ret;
		struct ht_ele *e;

		ret = ht_get_byindex(&t, index, &e);
		if (ret == -1)
			break;
		if (ret) {
			printf("%s\n", (char*) e->data);
		}
		index++;
	}

	ht_destroy(&t);

	return 0;
}
