/* Copyright (C) 2000,2001 Salvatore Sanfilippo <antirez@invece.org>
 * See the LICENSE file for more information. */

#include <stdio.h>
#include "ars.h"

int main(int argc, char **argv)
{
	struct ars_packet p;
	int j;
	int s;

	if (argc == 1) {
		printf("usage: example2 <packet_description>\n"
			"read the APD.txt file for more information\n");
		exit(1);
	}

	ars_init(&p);

	s = ars_open_rawsocket(&p);
	if (s == -ARS_ERROR) {
		perror("Opening raw socket");
		exit(1);
	}
	if (ars_d_build(&p, argv[1]) != ARS_OK) {
		printf("Error: %s\n", p.p_error);
		exit(1);
	}
	if (ars_compile(&p) != -ARS_OK) {
		printf("Error compiling: %s\n", p.p_error);
		exit(1);
	}
	ars_send(s, &p, NULL, 0);

	for (j = 0; j < ARS_MAX_LAYER; j++) {
		if (p.p_layer[j].l_type == ARS_TYPE_NULL)
			break;
		printf("layer %02d size %02d rel_size: %02d type: %s\n", j, p.p_layer[j].l_size, ars_relative_size(&p, j), ars_linfo[p.p_layer[j].l_type].li_name);
	}
	return 0;
}
