/* ==========================================================================
 * parseopt-test.c
 * ==========================================================================
 * parseopt test program.
 * --------------------------------------------------------------------------
 *   AUTHOR:  Marco Pantaleoni         E-mail: panta@elasticworld.org
 *
 *   Created: Wed Nov 15 20:38:10 CET 2000
 *
 *   $Id: parseopt-test.c,v 1.1.1.1 2001/04/03 10:19:14 antirez Exp $
 * --------------------------------------------------------------------------
 *    Copyright (C) 2000 Marco Pantaleoni. All rights reserved.
 *
 *  The contents of this file are subject to the elastiC License version 1.0
 *  (the "elastiC License"); you may not use this file except in compliance
 *  with the elastiC License. You may obtain a copy of the elastiC License at
 *  http://www.elasticworld.org/LICENSE
 *
 *  IN NO EVENT SHALL THE AUTHOR OR DISTRIBUTORS BE LIABLE TO ANY PARTY
 *  FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY
 *  DERIVATIVES THEREOF, EVEN IF THE AUTHOR HAS BEEN ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 *
 *  THE AUTHOR AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES,
 *  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THIS SOFTWARE
 *  IS PROVIDED ON AN "AS IS" BASIS, AND THE AUTHOR AND DISTRIBUTORS HAVE
 *  NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR
 *  MODIFICATIONS.
 *
 *  See the elastiC License for the specific language governing rights and
 *  limitations under the elastiC License.
 * ==========================================================================
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "parseopt.h"

#define PROGNAME "parseopt-test"
#define VERSION  "0.2"

static int add_parameter(const char *parameter, void *clientdata);

static void usage(const char *helpmsg);

int main(int argc, char *argv[])
{
	int         enable_devel_flag = 0;
	int         enable_devil_flag = 0;
	int         enable_evil_flag  = 0;
	int         help_flag         = 0;
	const char *with_spice_arg    = NULL;

	popt_specifier spec[] =
	{
		{ "enable-devel", 'd',  popt_argument_none,             NULL,
		  "enable developer mode",    NULL,       NULL, NULL, NULL,            &enable_devel_flag },

		{ "enable-devil", '\0', popt_argument_none,             NULL,
		  "enable devil mode",        NULL,       NULL, NULL, NULL,            &enable_devil_flag },

		{ "enable-evil",  '\0', popt_argument_none,             NULL,
		  "enable evil mode",         NULL,       NULL, NULL, NULL,            &enable_evil_flag  },

		{ "with-spice",   's',  popt_argument_optional_default, "yes",
		  "add spice (default: yes)", "[yes,no]", NULL, NULL, &with_spice_arg, NULL               },

		{ "help",         'h',  popt_argument_none,             NULL,
		  "show this help",           NULL,       NULL, NULL, NULL,            &help_flag         },

		{ NULL,           '\0', popt_argument_none,             NULL,
		  NULL,                       NULL,       NULL, NULL, NULL,            NULL               }
	};
	popt_return  rv;

	char *helpmsg = NULL;

	rv = popt_parse(argc, argv, spec, TRUE, TRUE, add_parameter, NULL);
	switch (rv)
	{
	case popt_ok:
		break;

	case popt_error_unknown:
		fprintf(stderr, "error parsing command line\n");
		exit(EXIT_FAILURE);
		break;

	case popt_error_unknown_option:
		fprintf(stderr, "uknown option\n");
		exit(EXIT_FAILURE);
		break;

	case popt_error_unexpected_argument:
		fprintf(stderr, "unexpected argument\n");
		exit(EXIT_FAILURE);
		break;

	case popt_error_missing_argument:
		fprintf(stderr, "argument is missing\n");
		exit(EXIT_FAILURE);
		break;

	case popt_error_invalid:
		fprintf(stderr, "invalid option\n");
		exit(EXIT_FAILURE);
		break;
	}

	if (help_flag || (argc == 1))
	{
		helpmsg = popt_make_help(spec);

		usage(helpmsg);

		free(helpmsg);
		exit(EXIT_FAILURE);
	}

	printf("enable-devel: %d\n",   enable_devel_flag);
	printf("enable-devil: %d\n",   enable_devil_flag);
	printf("enable-evil : %d\n",   enable_evil_flag);
	if (with_spice_arg)
		printf("with-spice  : '%s'\n", with_spice_arg);

	exit(EXIT_SUCCESS);
}

static int add_parameter(const char *parameter, void *clientdata)
{
	printf("Parameter: '%s'\n", parameter);
	return TRUE;
}

static void usage(const char *helpmsg)
{
	fprintf(stderr, "%s version %s\n\n", PROGNAME, VERSION);
	fprintf(stderr,
			"  Usage: %s [OPTION]... PARAMETER...\n\n"
			"Options\n"
			"%s",
			PROGNAME,
			helpmsg);
}
