/* ==========================================================================
 * parseopt.h
 * ==========================================================================
 * Command line options parsing.
 * --------------------------------------------------------------------------
 *   AUTHOR:  Marco Pantaleoni         E-mail: panta@elasticworld.org
 *
 *   Created: Wed Nov 15 19:24:43 CET 2000
 *
 *   $Id: parseopt.h,v 1.1.1.1 2001/04/03 10:19:16 antirez Exp $
 * --------------------------------------------------------------------------
 *    Copyright (C) 2000 Marco Pantaleoni. All rights reserved.
 *
 *  The contents of this file are subject to the elastiC License version 1.0
 *  (the "elastiC License"); you may not use this file except in compliance
 *  with the elastiC License. You may obtain a copy of the elastiC License at
 *  http://www.elasticworld.org/LICENSE
 *
 *  IN NO EVENT SHALL THE AUTHOR OR DISTRIBUTORS BE LIABLE TO ANY PARTY
 *  FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY
 *  DERIVATIVES THEREOF, EVEN IF THE AUTHOR HAS BEEN ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 *
 *  THE AUTHOR AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES,
 *  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THIS SOFTWARE
 *  IS PROVIDED ON AN "AS IS" BASIS, AND THE AUTHOR AND DISTRIBUTORS HAVE
 *  NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR
 *  MODIFICATIONS.
 *
 *  See the elastiC License for the specific language governing rights and
 *  limitations under the elastiC License.
 * ==========================================================================
 */

#ifndef __PARSEOPT_H
#define __PARSEOPT_H

#ifndef TRUE
#define TRUE  1
#define FALSE 0
#endif

typedef enum
{
	popt_argument_none,											/* no argument expected                        */
	popt_argument_optional,										/* argument is optional                        */
	popt_argument_optional_default,								/* argument is optional, a default is supplied */
	popt_argument_required										/* argument is required                        */
} popt_argtype;

typedef enum
{
	popt_ok,
	popt_error_unknown,											/* unknown error           */
	popt_error_unknown_option,									/* unknown option          */
	popt_error_unexpected_argument,								/* argument was unexpected */
	popt_error_missing_argument,								/* argument is missing     */
	popt_error_invalid											/* invalid option/argument */
} popt_return;

typedef struct popt_specifier_struct popt_specifier;

typedef int (*popt_validate)(popt_specifier *spec,				/* callback called to validate an argument    */
							 const char *argument,
							 void *client_data);

typedef int (*popt_parameter)(const char *parameter,			/* callback called when a non-option is found */
							  void *client_data);

struct popt_specifier_struct
{
	const char      *long_name;									/* long option name  (form --name)                 */
	char             short_name;								/* short option name (form -name)                  */

	popt_argtype     argument_type;
	const char      *defval;									/* default for argument_optional_default           */

	const char      *description;								/* option description (for help generation)        */
	const char      *argdescription;							/* allowed arguments descripion                    */

	popt_validate    validate_cb;								/* validation callback                             */
	void            *validate_clientdata;						/* validation callback client data                 */

	const char     **argument;									/* the argument (if present) is saved here         */
	int             *value;										/* variable incremented whenever the flag is found */
};

popt_return popt_parse(int argc, char * const argv[],
					   popt_specifier *specifiers,
					   int allow_partial,
					   int allow_collapsed,
					   popt_parameter parameter_cb,
					   void *parameter_cb_clientdata);

char *popt_make_help(popt_specifier *specifiers);

int popt_validate_int(popt_specifier   *spec, const char *argument, void *resp);
int popt_validate_float(popt_specifier *spec, const char *argument, void *resp);
int popt_validate_yesno(popt_specifier *spec, const char *argument, void *resp);
int popt_validate_bool(popt_specifier  *spec, const char *argument, void *resp);

#endif __PARSEOPT_H
