.TH netperf 1L ""
.SH NAME

netperf \- a network performance benchmark

.SH SYNOPSIS

.B netperf
[-H remotehost] [-t testname ]

.SH DESCRIPTION
.B Netperf
is a benchmark that can be used to measure various aspects of
networking performance.
Currently, its focus is on bulk data transfer and request/response
performance using either TCP or UDP, and the Berkeley Sockets interface.

.SS OPTIONS

.TP
.B \-a sizespec
Alter the send and receive buffer alignments on the local system.
This defaults to 8 bytes.
.TP
.B \-A sizespec
As -a, but for the remote system.
.TP
.B \-c [rate]
Request CPU utilization and service demand calculations for the
local system. If the optional rate parameter is specified,
.B netperf
will use that instead of calculating the rate itself.
.TP
.B \-C [rate]
As -c, but for the remote system.
.TP
.B \-d
Increase the quantity of debugging output displayed during
a test (possibly at the expense of performance).
.TP
.B \-D
Set the TCP_NODELAY option on both the local and remote systems.
.TP
.B \-f GMKgmk
Change the units of measure for stream tests.
.TP
.B \-h
Display a usage string, and exit.
.TP
.B \-H
Set the hostname (or IP address) of the remote system.
.TP
.B \-l testlen
Specify the length of the test (default 10 seconds).
A negative value sets the number of request/response transactions,
or the number of bytes for a stream test.
.TP
.B \-m size
Set the number of bytes in each send call (STREAM tests only).
.TP
.B \-M size
Set the size of the receives on the remote system (STREAM tests only).
.TP
.B \-o sizespec
Set an offset from the alignment specified with -a.
.TP
.B \-O sizespec
As -o, but for the remote system.
.TP
.B \-p portnum
Connect to a
.C netsetver
listening on the specified port, rather than using /etc/services.
.TP
.B \-P 0|1
Show (1) or suppress (0) the test banner.
.TP
.B \-r sizespec
Set the size of requests and responses.
This defaults to 100 bte requests, and 200 bytes responses.
.TP
.B \-s sizespec
Set the send and receive socket buffer sizes for the local system.
.TP
.B \-S sizespec
As -s, but for the remote system.
.TP
.B \-t testname
Specify the test to perform.
Valid testnames are:
.RS
.RS
.nf
.I TCP_STREAM
.I TCP_RR
.I UDP_STREAM
.I UDP_RR
.I LOC_CPU
.I REM_CPU
.fi
.RE
.RE
.TP
.B \-v verbosity
Set the verbosity level for the test (only with -P).
.TP
.B \-V
Enable the copy-avoidance features (HP-UX 9.0 only).

.SH SEE ALSO
.C netserver
.br
.I
Netperf: A Network Performance Benchmark

.SH AUTHORS
HP Information Networks Division - Networking Performance Team.
.br
Rick Jones	<raj@cup.hp.com>
.br
Karen Choy	HP IND
.br
Dave Shield	<daves@csc.liv.ac.uk>	(man pages)
