char   netcpu_perfstat_id[]="\
@(#)netcpu_perfstat.c Version 2.4.0";

#if HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdio.h>

#if HAVE_INTTYPES_H
# include <inttypes.h>
#else
# if HAVE_STDINT_H
#  include <stdint.h>
# endif
#endif

#include <libperfstat.h>

#include "netsh.h"
#include "netlib.h"

void
cpu_util_init(void) 
{
  return;
}

void
cpu_util_terminate(void)
{
  return;
}

int
get_cpu_method(void)
{
  return PERFSTAT;
}

void
get_cpu_idle(uint64_t *res)
{
  perfstat_cpu_t *perfstat_buffer;
  perfstat_cpu_t *per_cpu_pointer;
  perfstat_id_t  name;
  int ret;
  
  /* a name of "" will cause us to start from the beginning */
  strcpy(name.name,"");
  perfstat_buffer = (perfstat_cpu_t *)malloc(lib_num_loc_cpus *
					     sizeof(perfstat_cpu_t));
  if (perfstat_buffer == NULL) {
    fprintf(where,
	    "cpu_start: malloc failed errno %d\n",
	    errno);
    fflush(where);
    exit(-1);
  }
  
  /* happiness and joy, keep going */
  ret = perfstat_cpu(&name,
		     perfstat_buffer,
		     sizeof(perfstat_cpu_t),
		     lib_num_loc_cpus);
  
  if ((ret == -1) || 
      (ret != lib_num_loc_cpus)) {
    fprintf(where,
	    "cpu_start: perfstat_cpu failed/count off; errno %d cpus %d count %d\n",
	    errno,
	    lib_num_loc_cpus,
	    ret);
    fflush(where);
    exit(-1);
  }
  
  per_cpu_pointer = perfstat_buffer;
  for (i = 0; i < lib_num_loc_cpus; i++){
    res[i] = per_cpu_pointer->idle;
    per_cpu_pointer++;
  }
  free(perfstat_buffer);
  
  return;
}

float
calibrate_idle_rate(int iterations, int interval)
{
  unsigned long long
    firstcnt[MAXCPUS],
    secondcnt[MAXCPUS];

  float 
    elapsed,
    temp_rate,
    rate[MAXTIMES],
    local_maxrate;

  long  
    sec,
    usec;

  int   
    i,
    j;
  
  struct  timeval time1, time2 ;
  struct  timezone tz;

  perfstat_cpu_t  *perfstat_buffer;
  perfstat_cpu_t  *per_cpu_pointer;
  perfstat_id_t   name;
  int ret;
  
  if (debug) {
    fprintf(where,"enter calibrate_perfstat\n");
    fflush(where);
  }

  if (iterations > MAXTIMES) {
    iterations = MAXTIMES;
  }

  local_maxrate = (float)-1.0;
  
  perfstat_buffer = (perfstat_cpu_t *)malloc(lib_num_loc_cpus *
                                             sizeof(perfstat_cpu_t));
  if (perfstat_buffer == NULL) {
    fprintf(where,
            "calibrate_perfstat: malloc failed errno %d\n",
            errno);
    fflush(where);
    exit(-1);
  }

  for(i = 0; i < iterations; i++) {
    rate[i] = (float)0.0;
    /* a name of "" will cause us to start from the beginning */
    strcpy(name.name,"");
     
    /* happiness and joy, keep going */
    ret = perfstat_cpu(&name,
                       perfstat_buffer,
                       sizeof(perfstat_cpu_t),
                       lib_num_loc_cpus);
    
    if ((ret == -1) || 
        (ret != lib_num_loc_cpus)) {
      fprintf(where,
              "calibrate_perfstat: perfstat_cpu failed/count off; errno %d cpus %d count %d\n",
              errno,
              lib_num_loc_cpus,
              ret);
      fflush(where);
      exit(-1);
    }

    per_cpu_pointer = perfstat_buffer;
    for (j = 0; j < lib_num_loc_cpus; j++) {
      firstcnt[j] = per_cpu_pointer->idle;
      per_cpu_pointer++;
    }
    gettimeofday (&time1, &tz);
    sleep(interval);
    gettimeofday (&time2, &tz);

    if (time2.tv_usec < time1.tv_usec)
      {
        time2.tv_usec += 1000000;
        time2.tv_sec -=1;
      }
    sec = time2.tv_sec - time1.tv_sec;
    usec = time2.tv_usec - time1.tv_usec;
    elapsed = (float)sec + ((float)usec/(float)1000000.0);

    /* happiness and joy, keep going */
    ret = perfstat_cpu(&name,
                       perfstat_buffer,
                       sizeof(perfstat_cpu_t),
                       lib_num_loc_cpus);
    
    if ((ret == -1) || 
        (ret != lib_num_loc_cpus)) {
      fprintf(where,
              "calibrate_perfstat: perfstat_cpu failed/count off; errno %d cpus %d count %d\n",
              errno,
              lib_num_loc_cpus,
              ret);
      fflush(where);
      exit(-1);
    }

    per_cpu_pointer = perfstat_buffer;
    
    if(debug) {
      fprintf(where, "Calibration for perfstat counter run: %d\n",i);
      fprintf(where,"\tsec = %ld usec = %ld\n",sec,usec);
      fprintf(where,"\telapsed time = %g\n",elapsed);
    }

    for (j = 0; j < lib_num_loc_cpus; j++) {
      secondcnt[j] = per_cpu_pointer->idle;
      per_cpu_pointer++;
      if(debug) {
        /* I know that there are situations where compilers know about */
        /* long long, but the library functions do not... raj 4/95 */
        fprintf(where,
                "\tfirstcnt[%d] = 0x%8.8lx%8.8lx secondcnt[%d] = 0x%8.8lx%8.8lx\n",
                j,
                firstcnt[j],
                firstcnt[j],
                j,
                secondcnt[j],
                secondcnt[j]);
      }
      /* we assume that it would wrap no more than once. we also */
      /* assume that the result of subtracting will "fit" raj 4/95 */
      temp_rate = (secondcnt[j] >= firstcnt[j]) ?
        (float)(secondcnt[j] - firstcnt[j])/elapsed : 
          (float)(secondcnt[j]-firstcnt[j]+MAXLONG)/elapsed;
      if (temp_rate > rate[i]) rate[i] = temp_rate;
      if(debug) {
        fprintf(where,"\trate[%d] = %g\n",i,rate[i]);
        fflush(where);
      }
      if (local_maxrate < rate[i]) local_maxrate = rate[i];
    }
  }
  if(debug) {
    fprintf(where,"\tlocal maxrate = %g per sec. \n",local_maxrate);
    fflush(where);
  }
  free(perfstat_buffer);
  return local_maxrate;
}

