
/*
 
	      Copyright (C) 1998 Hewlett-Packard Company
                         ALL RIGHTS RESERVED.
 
  The enclosed software and documention includes copyrighted works of
  Hewlett-Packard Co. For as long as you comply with the following
  limitations, you are hereby authorized to (i) use, reproduce, and
  modify the software and documentation, and to (ii) distribute the
  software and documentation, including modifications, for
  non-commercial purposes only.
      
  1.  The enclosed software and documentation is made available at no
      charge in order to advance the general development of
      high-performance networking products.
 
  2.  You may not delete any copyright notices contained in the
      software or documentation. All hard copies, and copies in
      source code or object code form, of the software or
      documentation (including modifications) must contain at least
      one of the copyright notices.
 
  3.  The enclosed software and documentation has not been subjected
      to testing and quality control and is not a Hewlett-Packard Co.
      product. At a future time, Hewlett-Packard Co. may or may not
      offer a version of the software and documentation as a product.
  
  4.  THE SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS".
      HEWLETT-PACKARD COMPANY DOES NOT WARRANT THAT THE USE,
      REPRODUCTION, MODIFICATION OR DISTRIBUTION OF THE SOFTWARE OR
      DOCUMENTATION WILL NOT INFRINGE A THIRD PARTY'S INTELLECTUAL
      PROPERTY RIGHTS. HP DOES NOT WARRANT THAT THE SOFTWARE OR
      DOCUMENTATION IS ERROR FREE. HP DISCLAIMS ALL WARRANTIES,
      EXPRESS AND IMPLIED, WITH REGARD TO THE SOFTWARE AND THE
      DOCUMENTATION. HP SPECIFICALLY DISCLAIMS ALL WARRANTIES OF
      MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
  
  5.  HEWLETT-PACKARD COMPANY WILL NOT IN ANY EVENT BE LIABLE FOR ANY
      DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
      (INCLUDING LOST PROFITS) RELATED TO ANY USE, REPRODUCTION,
      MODIFICATION, OR DISTRIBUTION OF THE SOFTWARE OR DOCUMENTATION.
 
*/
char	netserver3_id[]="\
@(#)netserver3.c (c) Copyright 1998 Hewlett-Packard Co. Version 3.0.0";

 /***********************************************************************/
 /*									*/
 /*	netserver.c							*/
 /*									*/
 /*	This is the server side code for the netperf test package. It	*/
 /* will operate either stand-alone, or as a child of inetd. In this	*/
 /* way, we insure that it can be installed on systems with or without	*/
 /* root permissions (editing inetd.conf).                              */
 /*									*/
 /***********************************************************************/


/************************************************************************/
/*									*/
/*	Global include files						*/
/*									*/
/************************************************************************/
#include <sys/types.h>
#include <stdio.h>
#include <errno.h>
#include <signal.h>
#ifndef WIN32
#include <sys/ipc.h>
#endif /* WIN32 */
#include <fcntl.h>
#ifdef WIN32
#include <time.h>
#include <windows.h>
#include <winsock.h>
#else
#include <sys/time.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>
#ifndef DONT_WAIT
#include <sys/wait.h>
#endif /* DONT_WAIT */
#endif /* WIN32 */
#include <string.h>
#include <stdlib.h>

#include "netlib3.h"
#include "netperf3.h"

#include "nettest3_bsd.h"

#ifdef DO_DLPI
#include "nettest_dlpi.h"
#endif /* DO_DLPI */

#ifdef DO_IPV6
#include "nettest3_ipv6.h"
#endif /* DO_IPV6 */

#ifdef DO_DNS
#include "nettest3_dns.h"
#endif /* DO_DNS */

#ifndef DEBUG_LOG_FILE
#define DEBUG_LOG_FILE "/tmp/netperf.debug"
#endif /* DEBUG_LOG_FILE */

const char netserver_usage[] = "\n\
Usage: netserver [options] \n\
\n\
Options:\n\
    -h                Display this text\n\
    -p portnum        Listen for connect requests on portnum.\n\
\n";

 /* some global variables */

FILE	        *afp;
uint16_t	listen_port_num;
extern	char	*optarg;
extern	int	optind, opterr;

int forground = 0;
int server_sock;

#define SERVER_ARGS "dfn:p:"

void
print_netserver_usage()
{
  fprintf(stderr,netserver_usage);
}


 /* This routine implements the "main event loop" of the netperf
    server code. Code above it will have set-up the control connection
    and will have allocated a test structure  so this routine can just
    merrily go about its business, which is to execute  performance
    tests on the server. */ 

void 
process_requests(test_t *test)
{
  
  float	temp_rate;
  int32_t test_num;

  char test_message[MAX_CONTROL_MSG_LEN];

  /* we need a VASSERT on test being non-NULL */
  
  while (1) {
    if (debug) {
      fprintf(where,
	      "asking for a message on sock %d\n",
	      test->control_sock);
      fflush(where);
    }
    test_num = recv_control_message(test->control_sock,
				    1,
				    MAX_CONTROL_MSG_LEN,
				    test_message);

    if (debug) {
      fprintf(where,
	      "received |%40s| on control sock test_num %d\n",
	      test_message,test_num);
      fflush(where);
    }
    
    switch (test_num) {
      
    case VERSION:
      /* there will always be a version check when the control
	 connection is established. the version check will also
	 contain the netperf global settings and those settings will
	 be put into a test structre */

      if (debug) {
	fprintf(where,"Version Check\n");
	fflush(where);
      }

      sprintf(test_message,"%-60s","Netserver Version Check");
      send_control_message(test->control_sock,
			   VERSION,
			   strlen(test_message),
			   test_message);

#ifdef notdef
      make_args(test,test_message);
#endif      
      break;
      
    case REM_CPU:
      test->local_cpu_rate = 0.0;
      calibrate_local_cpu(test);

      /* we need the cpu_start, cpu_stop in the looper case to kill the */
      /* child proceses raj 7/95 */
      cpu_start(test);
      cpu_stop(test);

      /* when we are ready, put the send_control_message with the
	 calibration results here */
#ifdef notdef 
      send_response();
#endif
      break;
      
    case TCP_STREAM:
    case TCP_RR:
    case TCP_CRR:
    case TCP_CC:

#ifdef DO_1644
    case TCP_TRR:
#endif /* DO_1644 */
      
    case UDP_STREAM:
    case UDP_RR:
      
#ifdef DO_DLPI
    case DLPI_CO_RR:
    case DLPI_CL_RR:
    case DLPI_CO_STREAM:
    case DLPI_CL_STREAM:
#endif /* DO_DLPI */

#ifdef DO_XTI
    case XTI_TCP_STREAM:
    case XTI_TCP_RR:
    case XTI_UDP_STREAM:
    case XTI_UDP_RR:
#endif /* DO_XTI */

#ifdef DO_IPV6
    case TCPIPV6_STREAM:
    case TCPIPV6_RR:
    case TCPIPV6_CRR:
    case UDPIPV6_STREAM:
    case UDPIPV6_RR:
#endif /* DO_IPV6 */

#ifdef DO_DNS
    case DNS_RR:
#endif /* DO_DNS */

#ifdef DO_FTP
    case FTP_DOWNLOAD:
#endif /* DO_FTP */

	/* full steam ahead - call the test-specific "recv" routine */
	test->setup_message = strdup(test_message);
	netperf_switch[test_num][RECV](test);
	break;
    case SHUTDOWN:
      if (debug) {
	fprintf(where,"That's all folks!\n");
	fflush(where);
      }
      return;
      break;
    default:
      /* inform the requestor that the test type they have asked for
	 is unknown. */
      sprintf(test_message,"Test %d is unknown to netserver\n",test_num);
      send_control_message(test->control_sock,
			   ERROR,
			   strlen(test_message),
			   test_message);
      fprintf(where,test_message);
      exit(-1);
      break;
      
    }
  }
}

/* daemonize will fork a daemon into the background, freeing-up the
   shell prompt for other uses. I suspect that for non-Unix OSes,
   something other than fork() may be required? raj 2/98 */
void
daemonize()
{

  /* fork off - only the client will return, the parent will exit */
  
  switch (fork()) {
  case -1:
    /* something went wrong */
    perror("netserver fork error");
    exit(-1);
  case 0:
    /* we are the child process. set ourselves up ad the session
       leader so we detatch from the parent, and then return to the
       caller so he can do whatever it is he wants to do */

    fclose(stdin);
    fclose(stderr);

    setsid();

    /* not all OSes have SIGCLD as SIGCHLD */
#ifndef SIGCLD
#define SIGCLD SIGCHLD
#endif /* SIGCLD */
    
    signal(SIGCLD, SIG_IGN);

    break;
  default:
    /* we are the parent process - the one invoked from the
       shell. since the first child will detach itself, we can just go
       ahead and slowly fade away */
    exit(0);
  }
}

/*********************************************************************/
/*				       		                     */
/*	set_up_server()						     */
/*								     */
/* set-up the server listen socket. we only call this routine if the */
/* user has specified a port number on the command line.             */
/*								     */
/*********************************************************************/
/*KC*/

void 
set_up_server()
{ 
  struct sockaddr_in 	server;
  struct sockaddr_in 	peeraddr;

  int server_control;
  int peeraddr_len;
  int one=1;
  int request_num=0;

  test_t *test;

  server.sin_port = htons(listen_port_num);
  server.sin_addr.s_addr = INADDR_ANY;
  server.sin_family = AF_INET;
  
  printf("Starting netserver at port %d\n",listen_port_num);

  server_control = socket (AF_INET,SOCK_STREAM,0);
#ifdef WIN32
  if (server_control == INVALID_SOCKET)
#else
  if (server_control < 0)
#endif /* WIN32 */
    {
      perror("server_set_up: could not create the listen socket");
      exit(-1);
    }

  /* we need to set SO_REUSEADDR */
  if (setsockopt(server_control,
		 SOL_SOCKET,
		 SO_REUSEADDR,
		 &one,
		 sizeof(one)) !=0 ) {
    perror("server_set_up: SO_REUSEADDR failed");
    exit(-1);
  }
  

  if (bind(server_control,
	   (struct sockaddr *)&server, 
	   sizeof(struct sockaddr_in)) == -1)
    {
      perror("server_set_up: binding the socket failed");
      exit(-1);
    }
  
  /* the listen backlog probably should be a configurable parm */
  if (listen (server_control,20) == -1)
    {
      perror("server_set_up: setting the listen backlog failed");
      exit(-1);
    }
  
  /* if someone specifies -f, we will not daemonize. */
  if (!forground) {
    daemonize();
  }
  
  for (;;)
    {
      peeraddr_len = sizeof(peeraddr);
      if ((server_sock=accept(server_control,
			      (struct sockaddr *)&peeraddr,
			      &peeraddr_len)) == -1)
	{
	  fprintf(where,"server_control: accept failed\n");
	  fflush(where);
	  exit(-1);
	}
      
      if (debug) {
	fprintf(where,"accepted connection on sock %d\n",server_sock);
	fflush(where);
      }
      
      signal(SIGCLD, SIG_IGN);
      
      /* having accepted a connection, we want to see about
	 spawning-off a "thread" to handle this test request. if the
	 forground variable is greater than one, we will not spawn the
	 thread, but run process_requests synchronously - this will
	 have the side-effect of serializing any tests, but can be
	 useful when trying to debug stuff - following forks/threads
	 in a debugger can be something of a pain. raj 2/98 */
      
      if (forground > 1) {
	/* we are going to run tests serially */
	test = (test_t *)malloc(sizeof(test_t));
	test->control_sock = server_sock;
	
	if (debug) {
	  fprintf(where,
		  "allocated test struct at %p set control sock to %d\n",
		  test,test->control_sock);
	  fflush(where);
	}
	
	test->thread_num = request_num++;
	process_requests(test);

      }
      else {

	/* we are going to run requests concurrently */
	test = (test_t *)malloc(sizeof(test_t));
	test->thread_num = request_num++;
	test->control_sock = server_sock;
	
	if (debug) {
	  fprintf(where,"allocated test struct at %p set control sock to %d\n",
		  test,test->control_sock);
	  fflush(where);
	}

	/* why do I have the feeling that I have a non-trivial memory
	   leak here?-) raj 2/98 */
	
	start_worker(test,
		     (void *(*)())process_requests,
		     (void *)test,
		     1); /* magic number - do detach the "thread" */

#ifndef USE_THREADS

	/* we don't want to close the socket in the threaded case, but
	   we do in the process case or we will run-out of file
	   descriptors */
	close(server_sock);

	/* we also probably need to reap some children */
#ifndef DONT_WAIT
	while(waitpid(-1, NULL, WNOHANG) > 0) { }
#endif /* DONT_WAIT */
#endif /* USE_THREADS */
      }
    } /*for*/
  
}


int
main(argc, argv)
int argc;
char *argv[];
{

  int	c;
  test_t *test;

  struct sockaddr name;
  int namelen = sizeof(name);
  

#ifdef WIN32
	WSADATA	wsa_data ;

	/* Initialise the wsock lib ( version 1.1 ) */
	if ( WSAStartup(0x0101,&wsa_data) == SOCKET_ERROR ){
		printf("WSAStartup() fauled : %d\n",GetLastError()) ;
		return 1 ;
	}
#endif /* WIN32 */

  netlib3_init();
  
  /* Scan the command line to see if we are supposed to set-up our own */
  /* listen socket instead of relying on inetd. */
  
  while ((c = getopt(argc, argv, SERVER_ARGS)) != EOF) {
    switch (c) {
    case '?':
    case 'h':
      print_netserver_usage();
      exit(1);
    case 'd':
      /* we want to set the debug file name sometime */
      debug++;
      break;
    case 'f':
      forground++;
    case 'p':
      /* we want to open a listen socket at a */
      /* specified port number */
      listen_port_num = atoi(optarg);
      break;
    case 'n':
      shell_num_cpus = atoi(optarg);
      if (shell_num_cpus > NETPERF_MAX_CPUS) {
	fprintf(stderr,
		"netserver: This version can only support %d CPUs. Please",
		NETPERF_MAX_CPUS);
	fprintf(stderr,
		"           increase MAXCPUS in netlib.h and recompile.\n");
	fflush(stderr);
	exit(1);
      }
      break;

    }
  }

/*  unlink(DEBUG_LOG_FILE); */
  
  if ((where = fopen(DEBUG_LOG_FILE, "w")) == NULL) {
    perror("netserver: debug file");
    exit(1);
  }
  
  chmod(DEBUG_LOG_FILE,0644);
  
where = stdout;

  /* 
     we need to figure-out if we are a child of inetd or not. one of
     the checks is if we were given a port number in the argument list
     - if that is the case, we will create a standalone daemon for
     that port number (in other words, don't include a -p in the
     inetd.conf file :) 

     if we were not given a port number, we want to check and see if
     stdin is a socket - if it is a socket, then we will assume we are
     a child of inetd. if it is not a socket, we will assume that we
     were invoked from the command line without a -p option and will
     start a daemon at the default port number.
     */

  if (listen_port_num) {
    /* the user specified a port number on the command line */
    set_up_server();
  }
  else if (getsockname(0, &name, &namelen) == -1) {
    /* we may not be a child of inetd */
#ifdef WIN32
	  if (WSAGetLastError() == WSAENOTSOCK) {
#else 
	  if (errno == ENOTSOCK) {
#endif /* WIN32 */
	  listen_port_num = DEFAULT_CONTROL_PORT;
      set_up_server();
    }
  }
  else {
    /* we are probably a child of inetd */
    server_sock = 0;
    test = (test_t *)malloc(sizeof(test_t));
    process_requests(test);
  }
  return(0);
}


