#include "nettypes.h"

#define FTP_ARGS "DhH:L:m:M:p:s:u:w:W:"

/* at some point in the future we may get a bit fancier and have
   different sets of test-specific parms for each test within a suite,
   but for now we will have an amalgam just as in netperf 2.1. */ 

typedef struct ftp_test_parms {
  char test_dest[NETPERF_HOST_MAX];
  char test_source[NETPERF_HOST_MAX];
  char password[NETPERF_PWRD_MAX];
  char user[NETPERF_USER_MAX];
  char workload[NETPERF_FILE_MAX];
  char *mmap_base_addr;
  char *mmap_max_addr;
  int32_t client_socket_send;
  int32_t client_socket_recv;
  int32_t client_nodelay;
  int32_t send_size;
  int32_t client_watermark;
  int32_t recv_size;
} ftp_test_settings;

/* these are the definitions of the structure(s) used to hold the
   request info from the workload file. these magic numbers are the
   four characters of the nmemonic in ASCII codes. if I decide later
   that is too cute, i'll just number them starting from zero or
   semothing :) */

/* ok, using their ascii names _is_ too cute - it means I cannot
   efficiently use them as indices into an array of per-operation
   statistics. sooo, we'll revert to the traditional 0...N style. raj
   3/99 */ 

enum ftp_op_nums {
  CLOS = 0,
  CWD ,
  LIST,
  MDTM,
  NLST,
  NOOP,
  OPEN,
  PASS,
  PASV,
  PORT,
  PWD ,
  QUIT,
  REST,
  RETR,
  SIZE,
  STAT,
  SYST,
  TYPE,
  USER,
  WAIT,
  MAXOP
};

/* this needs to track the number of elts in the enum rather
   closely, or we might start stomping on data in a nasty way when we
   run off the end of an array... i'd love to know some way to make
   this more automagic... raj 4/99 */

#define MAXOPS 21

/* This will be the format of the requests that netperf will cycle
   through. when we are pulling requests from the shared memory
   segment, the overlay of the string might take us a bit past the
   current  request, but since the strings are supposed to be null
   terminated, i'm reasonably sure we will be OK. when we are pulling
   requests from the ascii file, this is the format of the request
   that will be filled-in and returned. we use an offset instead of a
   pointer so we can keep things densely packed and so we should avoid
   any 64 bit issues with pointer sizes. the offset is bytes from the
   beginning of the current struct to the next struct. */


typedef struct ftp_request_struct {
  int32_t     next_offset;
  int32_t     op_type;
  int         status;
  char        parm[BUFSIZ];
} ftp_request_t;

typedef struct ftp_op_res {
  uint64_t bytes_received; /* the number of bytes received for this op
			      type */
  uint32_t num_ok;   /* the number of ops which got the expected
			return value */
  uint32_t num_bad;  /* the number of ops which did not get the
			expected return value */
  struct timeval elapsed; /* the elapsed time for this op type */
} ftp_op_results;

typedef struct ftp_test_res {
  /* we have this here so we can know what things became without
     forcing extra setsockpt calls when we ask for defaults "value 0"
     and then overwrite the result with a getsockopt, causing a later
     iteration to think we were not asking for the defaults */
  ftp_test_settings final_settings;
  uint64_t bytes_received; /* overall bytes_received of data moving
			      ops */
  double   throughput;     /* overall throughput of data moving
			      operations in bytes per second */
  float    elapsed_time;   /* the elapsed time of the test */
  uint32_t num_receives;   /* the total number of ops performed */
  uint32_t segment_size;  
  ftp_op_results op_res[MAXOPS];
} ftp_test_results;

/* This is admittedly ugly, but necessary for my sanity and to make
   sure that when we change the sending side, we change the receiving
   side as well. */

/* sss = socket send size
   srs = socket recv size
   rs  = receive size
   ss  = send size
   nd  = nodelay
   tl  = test length
   rwm = recieve watermark
   td  = test destination
   wf  = workload file
   un  = user name
   pw  = password
   */

#define FTP_DOWNLOAD_REQ_COMM \
"tl %d sss %d srs %d rs %d ss %d nd %d rwm %d td %s wf %s un %s pw %s end"

/* append the "global" buffer settings to the various FTP_DOWNLOAD
   settings to arrive at the FTP_DOWNLOAD_REQ */

#define FTP_DOWNLOAD_REQ NETPERF_BUF_SETTINGS " " FTP_DOWNLOAD_REQ_COMM

#define FTP_DOWNLOAD_RSP FTP_DOWNLOAD_REQ_COMM

/* byr  - bytes received
   nrc  - number of receive calls
   tim  - elapsed time
   sdm  - service demand
   mth  - method used to measure CPU
   ncp  - number of CPU's
   */

#define FTP_DOWNLOAD_RES "byr %llu nrc %u tim %g sdm %g mth %d ncp %d end"

#define FTP_GO_MSG "Ready, Set, %s"


