/*
            Copyright (C) 2001 Ericsson 
                         ALL RIGHTS RESERVED.
 
  The enclosed software and documention includes copyrighted works of
  Ericsson. For as long as you comply with the following
  limitations, you are hereby authorized to (i) use, reproduce, and
  modify the software and documentation, and to (ii) distribute the
  software and documentation, including modifications, for
  non-commercial purposes only.
      
  1.  The enclosed software and documentation is made available at no
      charge in order to advance the general development of
      high-performance networking products.
 
  2.  You may not delete any copyright notices contained in the
      software or documentation. All hard copies, and copies in
      source code or object code form, of the software or
      documentation (including modifications) must contain at least
      one of the copyright notices.
 
  3.  The enclosed software and documentation has not been subjected
      to testing and quality control and is not a Ericsson 
      product. At a future time, Ericsson may or may not
      offer a version of the software and documentation as a product.
  
  4.  THE SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS".
      ERICSSON COMPANY DOES NOT WARRANT THAT THE USE,
      REPRODUCTION, MODIFICATION OR DISTRIBUTION OF THE SOFTWARE OR
      DOCUMENTATION WILL NOT INFRINGE A THIRD PARTY'S INTELLECTUAL
      PROPERTY RIGHTS. ERICSSON DOES NOT WARRANT THAT THE SOFTWARE OR
      DOCUMENTATION IS ERROR FREE. ERICSSON DISCLAIMS ALL WARRANTIES,
      EXPRESS AND IMPLIED, WITH REGARD TO THE SOFTWARE AND THE
      DOCUMENTATION. ERICSSON SPECIFICALLY DISCLAIMS ALL WARRANTIES OF
      MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
  
  5.  ERICSSON COMPANY WILL NOT IN ANY EVENT BE LIABLE FOR ANY
      DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
      (INCLUDING LOST PROFITS) RELATED TO ANY USE, REPRODUCTION,
      MODIFICATION, OR DISTRIBUTION OF THE SOFTWARE OR DOCUMENTATION.
 
*/

// PocketPerfDlg.cpp : Implementation file
//

#include "stdafx.h"
#include "PocketPerf.h"
#include "PocketPerfDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern "C" void shutdown_control(void); 
extern "C" void netlib_init(void); 
extern "C" void scan_cmd_line(int, char**);
extern "C" int establish_control(char hostname[], short int port); 
extern "C" void set_defaults();
extern "C" void rem_cpu_rate(void);
extern "C" void loc_cpu_rate(void);
extern "C" void send_udp_stream(char * const);
extern "C" void send_tcp_conn_rr(char * const, int, int);
extern "C" void send_tcp_rr(char * const);
extern "C" void send_tcp_stream(char * const);
extern "C" void send_udp_rr(char * const);
extern "C" unsigned int convert(char *);

extern "C" char* filename;
extern "C" int test_time;
extern "C" int send_size;
extern "C" int lss_size;
extern "C" int lsr_size;
extern "C" int rss_size;
extern "C" int rsr_size;


/////////////////////////////////////////////////////////////////////////////
// CPocketPerfDlg dialog

CPocketPerfDlg::CPocketPerfDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPocketPerfDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPocketPerfDlg)
	m_Port = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPocketPerfDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPocketPerfDlg)
	DDX_Control(pDX, IDC_EDITSOCKSIZE, m_SockSizeCtrl);
	DDX_Control(pDX, IDC_EDITMSGSIZE, m_MsgSizeCtrl);
	DDX_Control(pDX, IDC_EDITHOST3, m_HostCtrl3);
	DDX_Control(pDX, IDC_EDITTIME, m_TimeCtrl);
	DDX_Control(pDX, IDC_EDITLOCATION, m_LocationCtrl);
	DDX_Control(pDX, IDC_EDITHOST4, m_HostCtrl4);
	DDX_Control(pDX, IDC_EDITHOST2, m_HostCtrl2);
	DDX_Control(pDX, IDC_EDITHOST1, m_HostCtrl1);
	DDX_Control(pDX, IDC_COMBOTEST, m_TestCtrl);
	DDX_Control(pDX, IDC_EDITPORT, m_PortCtrl);
	DDX_Control(pDX, IDC_EDIT2, m_outCtrl);
	DDX_Text(pDX, IDC_EDITPORT, m_Port);
	DDV_MinMaxInt(pDX, m_Port, 1000, 99999);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPocketPerfDlg, CDialog)
	//{{AFX_MSG_MAP(CPocketPerfDlg)
	ON_BN_CLICKED(IDC_BUTTON1, OnExecute)
	ON_CBN_SELCHANGE(IDC_COMBOTEST, OnSelchangeTest)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPocketPerfDlg message handlers

BOOL CPocketPerfDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	CenterWindow(GetDesktopWindow());	// center to the hpc screen

	// Set pos i file to 0
	pos = 0;

	// Initiate ctrls
	m_HostCtrl1.SetWindowText(_T(""));
	m_HostCtrl2.SetWindowText(_T(""));
	m_HostCtrl3.SetWindowText(_T(""));
	m_HostCtrl4.SetWindowText(_T(""));
	
	m_PortCtrl.SetWindowText(_T("12865"));
	m_TimeCtrl.SetWindowText(_T("10"));
	m_MsgSizeCtrl.SetWindowText(_T("4K"));
	m_SockSizeCtrl.SetWindowText(_T("8K"));
	
	m_TestCtrl.AddString(_T("TCP_STREAM"));
	m_TestCtrl.AddString(_T("TCP_RR"));			
	m_TestCtrl.AddString(_T("UDP_STREAM"));
	m_TestCtrl.AddString(_T("UDP_RR"));			
	m_TestCtrl.SelectString(-1, _T("TCP_STREAM"));
	m_Test = _T("TCP_STREAM");

	return TRUE;  
}

void CPocketPerfDlg::OnExecute() 
{
	char list[5000];
	int estab = 0;

	// Create a wait cursor
	CWaitCursor wait;

	// Clear output
	m_outCtrl.SetWindowText(_T("\r\n\r\n\r\nTest in progress... "));

	// Init netlib...
	netlib_init();
	set_defaults();

	char host_name[25]; 
	CString test_name; 
	short test_port;;

	// Get IP address to Host
	WCHAR ip1[5], ip2[5], ip3[5], ip4[5];
	m_HostCtrl1.GetWindowText(ip1, 4);
	m_HostCtrl2.GetWindowText(ip2, 4);
	m_HostCtrl3.GetWindowText(ip3, 4);
	m_HostCtrl4.GetWindowText(ip4, 4);
	sprintf(host_name, "%S.%S.%S.%S", ip1, ip2, ip3, ip4);
	
	test_name = m_Test;

	// Get Port
	WCHAR wparam[30];
	char param[30];
	m_PortCtrl.GetWindowText(wparam, 6);
	sprintf(param, "%S", wparam);
	test_port = (short) atoi(param);

	// Get Time
	m_TimeCtrl.GetWindowText(wparam, 6);
	sprintf(param, "%S", wparam);
	test_time = (short) atoi(param);

	// Get Params
	
	/* Set the msg size */
	int c = m_MsgSizeCtrl.GetWindowText(wparam, 28);
	if (c > 0)
	{
		sprintf(param, "%S", wparam);
		send_size = convert(param);
		if (send_size == 0)
		{
			// Use default...
			send_size = 4096;
		}
	}
	else
	{
		// Use default...
		send_size = 4096;
	}

	/* Set the socket size */
	c = m_SockSizeCtrl.GetWindowText(wparam, 28);
	if (c > 0)
	{
		sprintf(param, "%S", wparam);
		int size = convert(param);
		if (size > 0)
		{
			lss_size = lsr_size = rss_size = rsr_size = size;
		}
		else
		{
			// Use default...
			lss_size = lsr_size = rss_size = rsr_size = 8192;
		}
	}
	else
	{
		// Use default...
		lss_size = lsr_size = rss_size = rsr_size = 8192;
	}

	if ((estab = establish_control(host_name,test_port)) == 0)
	{
		if (test_name.Compare(_T("TCP_STREAM")) == 0) {
			send_tcp_stream(host_name);
		}
		else if (test_name.Compare(_T("TCP_RR")) == 0) {
			send_tcp_rr(host_name);
		}
		else if (test_name.Compare(_T("UDP_STREAM")) == 0) {
			send_udp_stream(host_name);
		}
		else if (test_name.Compare(_T("UDP_RR")) == 0) {
			send_udp_rr(host_name);
		}
		else {
			m_outCtrl.SetWindowText(_T("The test you requested is unknown to this netperf.\r\n \
				Please verify that you have the correct test name, \r\n \
				and that test family has been compiled into this netperf.\r\n"));
		}

		shutdown_control();

		// Print output from netperf to dlg
		if ((outputFile = fopen("netperf_tmp.log", "rt")) != NULL)	// Only proceed if the file could be opened...
		{
			memset(list, 0, 5000);
			int nr = fread(list, sizeof( char ), 5000, outputFile);
			if (nr > 0)
			{
				list[nr] = '\0';	// Terminate string...
				int chars = (nr * sizeof( char ));
				pos += nr;

				WCHAR wlist [5000];
				swprintf(wlist, _T("%S"), list);
				m_outCtrl.SetWindowText(wlist);
				
				// Write data to logfile
				if ((logFile = fopen("netperf.log", "a+")) != NULL)	// Only proceed if the file could be opened...
				{
					// Get Info
					int c = m_LocationCtrl.GetWindowText(wparam, 28);
					sprintf(param, "%S", wparam);
					fwrite("Location: " ,sizeof( char ), 10 , logFile);
					fwrite(param, sizeof( char ), c , logFile);
					fwrite("\r\n", sizeof( char ), 2 , logFile); // Add a newline
					fwrite(list, sizeof( char ), nr , logFile); 
					fwrite("\r\n", sizeof( char ), 2 , logFile); // Add a newline
					fclose(logFile);
				}
			}
			fclose(outputFile);
		}
	}
	else
	{    
		m_outCtrl.SetWindowText(_T("Unable to connect to netserver..."));
	}
	MessageBeep(0xFFFFFFFF);  // Beep

	// Remove wait cursor
	wait.Restore();
}

void CPocketPerfDlg::OnSelchangeTest() 
{
	// Get selected test case
	int i = m_TestCtrl.GetCurSel();
	m_TestCtrl.GetLBText(i, m_Test);
}
