# Copyright (C) 2005 Insecure.Com LLC.
#
# Author: Adriano Monteiro Marques   <py.adriano@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

import gtk
import gobject

class Splash(gtk.Window):
    def __init__(self, image, time=1500):
        gtk.Window.__init__(self, gtk.WINDOW_POPUP)
        self.set_position(gtk.WIN_POS_CENTER)

        self.splash_image = gtk.Image()
        self.splash_image.set_from_file(image)

        self.add(self.splash_image)
        self.show_all()
        
        while gtk.events_pending():
            gtk.main_iteration()
        gobject.timeout_add(time, self.destroy)
